/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation.validator;

import java.util.Arrays;
import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;
import liquibase.repackaged.net.sf.jsqlparser.statement.drop.Drop;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.NamedObject;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.AbstractValidator;

public class DropValidator
extends AbstractValidator<Drop> {
    @Override
    public void validate(Drop drop) {
        String string = drop.getType();
        for (ValidationCapability validationCapability : this.getCapabilities()) {
            this.validateFeature(validationCapability, Feature.drop);
            this.validateFeature(validationCapability, NamedObject.table.name().equalsIgnoreCase(string), Feature.dropTable);
            this.validateFeature(validationCapability, NamedObject.index.equalsIgnoreCase(string), Feature.dropIndex);
            this.validateFeature(validationCapability, NamedObject.view.equalsIgnoreCase(string), Feature.dropView);
            this.validateFeature(validationCapability, NamedObject.schema.equalsIgnoreCase(string), Feature.dropSchema);
            this.validateFeature(validationCapability, NamedObject.sequence.equalsIgnoreCase(string), Feature.dropSequence);
            this.validateFeature(validationCapability, drop.isIfExists() && NamedObject.table.name().equalsIgnoreCase(string), Feature.dropTableIfExists);
            this.validateFeature(validationCapability, drop.isIfExists() && NamedObject.index.equalsIgnoreCase(string), Feature.dropIndexIfExists);
            this.validateFeature(validationCapability, drop.isIfExists() && NamedObject.view.equalsIgnoreCase(string), Feature.dropViewIfExists);
            this.validateFeature(validationCapability, drop.isIfExists() && NamedObject.schema.equalsIgnoreCase(string), Feature.dropSchemaIfExists);
            this.validateFeature(validationCapability, drop.isIfExists() && NamedObject.sequence.equalsIgnoreCase(string), Feature.dropSequenceIfExists);
        }
        Object object = NamedObject.forName(string);
        if (Arrays.asList(NamedObject.table, NamedObject.view).contains(object)) {
            this.validateName((NamedObject)((Object)object), drop.getName().getFullyQualifiedName());
        }
    }
}

