/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.syncope.common.lib.scim.SCIMConf;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.core.logic.AbstractLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.logic.scim.SCIMConfManager;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.ext.scimv2.api.data.AuthenticationScheme;
import org.apache.syncope.ext.scimv2.api.data.BulkConfigurationOption;
import org.apache.syncope.ext.scimv2.api.data.ConfigurationOption;
import org.apache.syncope.ext.scimv2.api.data.FilterConfigurationOption;
import org.apache.syncope.ext.scimv2.api.data.Meta;
import org.apache.syncope.ext.scimv2.api.data.ResourceType;
import org.apache.syncope.ext.scimv2.api.data.SchemaExtension;
import org.apache.syncope.ext.scimv2.api.data.ServiceProviderConfig;
import org.apache.syncope.ext.scimv2.api.type.Resource;
import org.springframework.security.access.prepost.PreAuthorize;

public class SCIMLogic
extends AbstractLogic<EntityTO> {
    protected static final String SCHEMAS_JSON = "schemas.json";
    protected static final Object MONITOR = new Object();
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected static ServiceProviderConfig SERVICE_PROVIDER_CONFIG;
    protected static ResourceType USER;
    protected static ResourceType GROUP;
    protected String schemas;
    protected final Map<String, String> schemaMap = new HashMap<String, String>();
    protected final SCIMConfManager confManager;

    public SCIMLogic(SCIMConfManager confManager) {
        this.confManager = confManager;
    }

    protected void init() {
        try {
            ArrayNode attributes;
            ObjectNode extensionObject;
            JsonNode tree = MAPPER.readTree(SCIMLogic.class.getResourceAsStream("/schemas.json"));
            if (!tree.isArray()) {
                throw new IOException("JSON node is not a tree");
            }
            ArrayNode schemaArray = (ArrayNode)tree;
            SCIMConf conf = this.confManager.get();
            if (conf.getExtensionUserConf() != null) {
                extensionObject = MAPPER.createObjectNode();
                extensionObject.put("id", Resource.ExtensionUser.schema());
                extensionObject.put("name", conf.getExtensionUserConf().getName());
                extensionObject.put("description", conf.getExtensionUserConf().getDescription());
                attributes = MAPPER.createArrayNode();
                conf.getExtensionUserConf().getAttributes().forEach(scimItem -> {
                    ObjectNode attribute = MAPPER.createObjectNode();
                    attribute.put("name", scimItem.getIntAttrName());
                    attribute.put("type", "string");
                    attribute.put("multiValued", scimItem.isMultiValued());
                    attribute.put("required", scimItem.getMandatoryCondition());
                    attribute.put("caseExact", scimItem.isCaseExact());
                    attribute.put("mutability", scimItem.isMutability());
                    attribute.put("returned", scimItem.getReturned().getReturned());
                    attribute.put("uniqueness", scimItem.isUniqueness());
                    attributes.add((JsonNode)attribute);
                });
                extensionObject.putIfAbsent("attributes", (JsonNode)attributes);
                extensionObject.putIfAbsent("meta", MAPPER.readTree("{\"resourceType\": \"Schema\",\"location\": \"/v2/Schemas/urn:ietf:params:scim:schemas:extension:syncope:2.0:User\"}"));
                schemaArray.add((JsonNode)extensionObject);
            }
            if (conf.getExtensionGroupConf() != null) {
                extensionObject = MAPPER.createObjectNode();
                extensionObject.put("id", Resource.ExtensionGroup.schema());
                extensionObject.put("name", conf.getExtensionGroupConf().getName());
                extensionObject.put("description", conf.getExtensionGroupConf().getDescription());
                attributes = MAPPER.createArrayNode();
                conf.getExtensionGroupConf().getAttributes().forEach(scimItem -> {
                    ObjectNode attribute = MAPPER.createObjectNode();
                    attribute.put("name", scimItem.getIntAttrName());
                    attribute.put("type", "string");
                    attribute.put("multiValued", scimItem.isMultiValued());
                    attribute.put("required", scimItem.getMandatoryCondition());
                    attribute.put("caseExact", scimItem.isCaseExact());
                    attribute.put("mutability", scimItem.isMutability());
                    attribute.put("returned", scimItem.getReturned().getReturned());
                    attribute.put("uniqueness", scimItem.isUniqueness());
                    attributes.add((JsonNode)attribute);
                });
                extensionObject.putIfAbsent("attributes", (JsonNode)attributes);
                extensionObject.putIfAbsent("meta", MAPPER.readTree("{\"resourceType\": \"Schema\",\"location\": \"/v2/Schemas/urn:ietf:params:scim:schemas:extension:syncope:2.0:Group\"}"));
                schemaArray.add((JsonNode)extensionObject);
            }
            if (!conf.getExtensionAnyObjectsConf().isEmpty()) {
                conf.getExtensionAnyObjectsConf().forEach(confItem -> {
                    ObjectNode extensionObject = MAPPER.createObjectNode();
                    extensionObject.put("id", "urn:ietf:params:scim:schemas:extension:syncope:2.0:" + confItem.getType());
                    extensionObject.put("name", confItem.getName());
                    extensionObject.put("description", confItem.getDescription());
                    ArrayNode attributes = MAPPER.createArrayNode();
                    confItem.getAttributes().forEach(scimItem -> {
                        ObjectNode attribute = MAPPER.createObjectNode();
                        attribute.put("name", scimItem.getIntAttrName());
                        attribute.put("type", "string");
                        attribute.put("multiValued", scimItem.isMultiValued());
                        attribute.put("required", scimItem.getMandatoryCondition());
                        attribute.put("caseExact", scimItem.isCaseExact());
                        attribute.put("mutability", scimItem.isMutability());
                        attribute.put("returned", scimItem.getReturned().getReturned());
                        attribute.put("uniqueness", scimItem.isUniqueness());
                        attributes.add((JsonNode)attribute);
                    });
                    extensionObject.putIfAbsent("attributes", (JsonNode)attributes);
                    try {
                        extensionObject.putIfAbsent("meta", MAPPER.readTree("{\"resourceType\": \"Schema\",\"location\": \"/v2/Schemas/urn:ietf:params:scim:schemas:extension:syncope:2.0:" + confItem.getType() + "}\""));
                    }
                    catch (IOException e) {
                        LOG.error("Could not parse the default schema definitions", (Throwable)e);
                    }
                    schemaArray.add((JsonNode)extensionObject);
                });
            }
            this.schemas = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)tree);
            this.schemaMap.clear();
            for (JsonNode schema : schemaArray) {
                this.schemaMap.put(schema.get("id").asText(), MAPPER.writeValueAsString((Object)schema));
            }
        }
        catch (IOException e) {
            LOG.error("Could not parse the default schema definitions", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="isAuthenticated()")
    public ServiceProviderConfig serviceProviderConfig(UriBuilder uriBuilder) {
        this.init();
        Object object = MONITOR;
        synchronized (object) {
            if (SERVICE_PROVIDER_CONFIG == null) {
                SCIMConf conf = this.confManager.get();
                SERVICE_PROVIDER_CONFIG = new ServiceProviderConfig(new Meta(Resource.ServiceProviderConfig.name(), conf.getGeneralConf().getCreationDate(), conf.getGeneralConf().getLastChangeDate(), conf.getGeneralConf().getETagValue(), uriBuilder.build(new Object[0]).toASCIIString()), new ConfigurationOption(true), new BulkConfigurationOption(false, conf.getGeneralConf().getBulkMaxOperations(), conf.getGeneralConf().getBulkMaxPayloadSize()), new FilterConfigurationOption(true, conf.getGeneralConf().getFilterMaxResults()), new ConfigurationOption(true), new ConfigurationOption(true), new ConfigurationOption(true));
                SERVICE_PROVIDER_CONFIG.getAuthenticationSchemes().add(new AuthenticationScheme("JSON Web Token", "Apache Syncope JWT authentication", URI.create("http://www.rfc-editor.org/info/rfc6750"), URI.create("https://syncope.apache.org/docs/reference-guide.html#rest-authentication-and-authorization"), "oauthbearertoken", true));
                SERVICE_PROVIDER_CONFIG.getAuthenticationSchemes().add(new AuthenticationScheme("HTTP Basic", "Apache Syncope HTTP Basic authentication", URI.create("http://www.rfc-editor.org/info/rfc2617"), URI.create("https://syncope.apache.org/docs/reference-guide.html#rest-authentication-and-authorization"), "httpbasic", false));
            }
        }
        return SERVICE_PROVIDER_CONFIG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="isAuthenticated()")
    public List<ResourceType> resourceTypes(UriBuilder uriBuilder) {
        Object object = MONITOR;
        synchronized (object) {
            String uri = uriBuilder.build(new Object[0]).toASCIIString();
            if (USER == null) {
                USER = new ResourceType("User", "User", "/Users", "User Account", Resource.User.schema(), new Meta(Resource.ResourceType.name(), null, null, null, uri + "User"));
                USER.getSchemaExtensions().add(new SchemaExtension(Resource.EnterpriseUser.schema(), true));
            }
            if (GROUP == null) {
                GROUP = new ResourceType("Group", "Group", "/Groups", "Group", Resource.Group.schema(), new Meta(Resource.ResourceType.name(), null, null, null, uri + "Group"));
            }
        }
        return List.of(USER, GROUP);
    }

    @PreAuthorize(value="isAuthenticated()")
    public ResourceType resourceType(UriBuilder uriBuilder, String type) {
        if (Resource.User.name().equals(type)) {
            this.resourceTypes(uriBuilder);
            return USER;
        }
        if (Resource.Group.name().equals(type)) {
            this.resourceTypes(uriBuilder);
            return GROUP;
        }
        throw new IllegalArgumentException("Unsupported resource type: " + type);
    }

    @PreAuthorize(value="isAuthenticated()")
    public String schemas() {
        this.init();
        return this.schemas;
    }

    @PreAuthorize(value="isAuthenticated()")
    public String schema(String schema) {
        this.init();
        String found = this.schemaMap.get(schema);
        if (found == null) {
            throw new NotFoundException("Schema " + schema + " not found");
        }
        return found;
    }

    protected EntityTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

