/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.AbstractSchemaDetailsPanel;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.to.VirSchemaTO;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class VirSchemaDetails
extends AbstractSchemaDetailsPanel {
    private static final long serialVersionUID = 5979623248182851337L;
    @SpringBean
    protected ResourceRestClient resourceRestClient;
    @SpringBean
    protected ConnectorRestClient connectorRestClient;
    protected final Map<String, String> anyTypes = new HashMap<String, String>();
    protected final AjaxDropDownChoicePanel<String> anyType;
    protected ResourceTO selectedResource;

    public VirSchemaDetails(String id, VirSchemaTO schemaTO) {
        super(id, (SchemaTO)schemaTO);
        AjaxCheckBoxPanel readonly = new AjaxCheckBoxPanel("readonly", this.getString("readonly"), (IModel)new PropertyModel((Object)schemaTO, "readonly"));
        this.add(new Component[]{readonly});
        final AjaxDropDownChoicePanel resource = new AjaxDropDownChoicePanel("resource", this.getString("resource"), (IModel)new PropertyModel((Object)schemaTO, "resource"), false).setNullValid(false);
        resource.setChoices(this.resourceRestClient.list().stream().map(ResourceTO::getKey).collect(Collectors.toList()));
        resource.setOutputMarkupId(true);
        resource.addRequiredLabel();
        if (resource.getModelObject() != null) {
            this.populateAnyTypes((String)((Object)resource.getModelObject()));
        }
        this.add(new Component[]{resource});
        this.anyType = new AjaxDropDownChoicePanel("anyType", this.getString("anyType"), (IModel)new PropertyModel((Object)schemaTO, "anyType"), false).setNullValid(false);
        this.anyType.setChoices(new ArrayList<String>(this.anyTypes.keySet()));
        this.anyType.setOutputMarkupId(true);
        this.anyType.setOutputMarkupPlaceholderTag(true);
        this.anyType.addRequiredLabel();
        if (resource.getModelObject() == null) {
            this.anyType.setEnabled(false);
        }
        this.add(new Component[]{this.anyType});
        final AjaxTextFieldPanel extAttrName = new AjaxTextFieldPanel("extAttrName", this.getString("extAttrName"), (IModel)new PropertyModel((Object)schemaTO, "extAttrName"));
        extAttrName.setOutputMarkupId(true);
        extAttrName.addRequiredLabel();
        if (this.selectedResource != null) {
            extAttrName.setChoices(this.getExtAttrNames());
        }
        this.add(new Component[]{extAttrName});
        resource.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                VirSchemaDetails.this.anyTypes.clear();
                if (resource.getModelObject() != null) {
                    VirSchemaDetails.this.populateAnyTypes((String)((Object)resource.getModelObject()));
                    VirSchemaDetails.this.anyType.setEnabled(true);
                }
                VirSchemaDetails.this.anyType.setChoices(new ArrayList<String>(VirSchemaDetails.this.anyTypes.keySet()));
                VirSchemaDetails.this.anyType.setModelObject(null);
                target.add(new Component[]{VirSchemaDetails.this.anyType});
            }
        }});
        this.anyType.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (VirSchemaDetails.this.selectedResource != null) {
                    String adminRealm = VirSchemaDetails.this.getAdminRealm(VirSchemaDetails.this.selectedResource.getConnector());
                    if (SyncopeConsoleSession.get().owns("CONNECTOR_READ", new String[]{adminRealm})) {
                        extAttrName.setChoices(VirSchemaDetails.this.getExtAttrNames());
                        target.add(new Component[]{extAttrName});
                    }
                }
            }
        }});
    }

    protected String getAdminRealm(String connectorKey) {
        String adminRealm = null;
        try {
            adminRealm = this.connectorRestClient.read(connectorKey).getAdminRealm();
        }
        catch (Exception e) {
            LOG.error("Could not read Admin Realm for External Resource {}", (Object)this.selectedResource.getKey());
        }
        return adminRealm;
    }

    protected void populateAnyTypes(String resourceKey) {
        this.anyTypes.clear();
        if (resourceKey != null) {
            ResourceTO resource = this.resourceRestClient.read(resourceKey);
            String adminRealm = this.getAdminRealm(resource.getConnector());
            if (SyncopeConsoleSession.get().owns("RESOURCE_READ", new String[]{adminRealm})) {
                this.selectedResource = resource;
                this.selectedResource.getProvisions().forEach(provisionTO -> this.anyTypes.put(provisionTO.getAnyType(), provisionTO.getObjectClass()));
            }
        }
    }

    protected List<String> getExtAttrNames() {
        return this.connectorRestClient.getExtAttrNames("/", this.anyTypes.get(this.anyType.getModelObject()), this.selectedResource.getConnector(), this.selectedResource.getConfOverride());
    }
}

