/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service.wa;

import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.wa.U2FDevice;
import org.apache.syncope.common.rest.api.beans.U2FDeviceQuery;
import org.apache.syncope.common.rest.api.service.wa.U2FRegistrationService;
import org.apache.syncope.core.logic.wa.U2FRegistrationLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractService;
import org.springframework.stereotype.Service;

@Service
public class U2FRegistrationServiceImpl
extends AbstractService
implements U2FRegistrationService {
    protected final U2FRegistrationLogic logic;

    public U2FRegistrationServiceImpl(U2FRegistrationLogic logic) {
        this.logic = logic;
    }

    public void delete(U2FDeviceQuery query) {
        this.logic.delete(query.getId(), query.getExpirationDate());
    }

    public void create(String owner, U2FDevice device) {
        this.logic.create(owner, device);
    }

    public PagedResult<U2FDevice> search(U2FDeviceQuery query) {
        Pair result = this.logic.search(query.getPage(), query.getSize(), query.getId(), query.getExpirationDate(), this.getOrderByClauses(query.getOrderBy()));
        return this.buildPagedResult((List)result.getRight(), query.getPage(), query.getSize(), (Integer)result.getLeft());
    }
}

