/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.egrid.component;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public abstract class EditableGridSubmitLink
extends AjaxSubmitLink {
    private static final long serialVersionUID = 1L;
    private final WebMarkupContainer encapsulatingContainer;

    protected abstract void onSuccess(AjaxRequestTarget var1);

    protected abstract void onError(AjaxRequestTarget var1);

    public EditableGridSubmitLink(String id, WebMarkupContainer newEncapsulatingComponent) {
        super(id);
        this.encapsulatingContainer = newEncapsulatingComponent;
    }

    protected final void onSubmit(AjaxRequestTarget target) {
        if (this.isFormComponentsValid()) {
            this.updateFormComponentsModel();
            this.onSuccess(target);
        } else {
            this.onError(target);
        }
    }

    private boolean isFormComponentsValid() {
        final Boolean[] error = new Boolean[]{false};
        this.encapsulatingContainer.visitChildren(FormComponent.class, new IVisitor<FormComponent<?>, Void>(){

            public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                if (EditableGridSubmitLink.this.formComponentActive(formComponent)) {
                    formComponent.validate();
                    if (formComponent.isValid()) {
                        if (!formComponent.processChildren()) {
                            visit.dontGoDeeper();
                        }
                    } else {
                        error[0] = true;
                        visit.dontGoDeeper();
                    }
                }
                visit.dontGoDeeper();
            }
        });
        return error[0] == false;
    }

    private void updateFormComponentsModel() {
        this.encapsulatingContainer.visitChildren(FormComponent.class, new IVisitor<FormComponent<?>, Void>(){

            public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                if (EditableGridSubmitLink.this.formComponentActive(formComponent)) {
                    formComponent.updateModel();
                    if (!formComponent.processChildren()) {
                        visit.dontGoDeeper();
                    }
                }
                visit.dontGoDeeper();
            }
        });
    }

    private boolean formComponentActive(FormComponent<?> formComponent) {
        return formComponent.isVisibleInHierarchy() && formComponent.isValid() && formComponent.isEnabled() && formComponent.isEnableAllowed();
    }
}

