/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.window;

import java.io.Serializable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.string.Strings;

public class WindowButton
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private static final String ICON = "";
    private String name;
    private String icon;
    private boolean enabled;
    private boolean visible = true;
    private boolean formProcessing = true;
    private final IModel<String> model;

    public static WindowButton of(String name, IModel<String> model, boolean formProcessing) {
        return WindowButton.of(name, model, ICON, formProcessing);
    }

    public static WindowButton of(String name, IModel<String> model, String icon, boolean formProcessing) {
        WindowButton button = new WindowButton(name, model, icon);
        return button.setDefaultFormProcessing(formProcessing);
    }

    public WindowButton(String name, String text) {
        this(name, (IModel<String>)Model.of((Serializable)((Object)text)), ICON, true);
    }

    public WindowButton(String name, String text, String icon) {
        this(name, (IModel<String>)Model.of((Serializable)((Object)text)), icon, true);
    }

    public WindowButton(String name, String text, boolean enabled) {
        this(name, (IModel<String>)Model.of((Serializable)((Object)text)), ICON, enabled);
    }

    public WindowButton(String name, String text, String icon, boolean enabled) {
        this(name, (IModel<String>)Model.of((Serializable)((Object)text)), icon, enabled);
    }

    public WindowButton(String name, IModel<String> model) {
        this(name, model, ICON, true);
    }

    public WindowButton(String name, IModel<String> model, String icon) {
        this(name, model, icon, true);
    }

    public WindowButton(String name, IModel<String> model, boolean enabled) {
        this(name, model, ICON, enabled);
    }

    public WindowButton(String name, IModel<String> model, String icon, boolean enabled) {
        this.name = name;
        this.model = model;
        this.icon = icon;
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    IModel<String> getModel() {
        return this.model;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isIndicating() {
        return this.getDefaultFormProcessing();
    }

    public boolean getDefaultFormProcessing() {
        return this.formProcessing;
    }

    public WindowButton setDefaultFormProcessing(boolean processing) {
        this.formProcessing = processing;
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof WindowButton) {
            return this.match(((WindowButton)object).getName());
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean match(String name) {
        return Strings.isEqual((String)name, (String)this.name);
    }

    public String toString() {
        return this.name;
    }
}

