/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.util.ClassUtils;
import org.springmodules.cache.FatalCacheException;
import org.springmodules.cache.config.AbstractCacheSetupStrategyParser;
import org.springmodules.cache.config.CacheModelParser;
import org.springmodules.cache.config.CacheProxyFactoryBeanParser;
import org.springmodules.cache.config.CommonsAttributesParser;
import org.springmodules.cache.config.MethodMapInterceptorsParser;
import org.springmodules.cache.util.SystemUtils;

public abstract class AbstractCacheNamespaceHandler
extends NamespaceHandlerSupport {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    static /* synthetic */ Class class$org$springmodules$cache$config$AbstractCacheNamespaceHandler;

    public final void init() {
        this.registerBeanDefinitionParser("config", this.getCacheProviderFacadeParser());
        CacheModelParser cacheModelParser = this.getCacheModelParser();
        this.registerAnnotationsElementParser(cacheModelParser);
        this.registerCommonsAttributesElementParser(cacheModelParser);
        this.registerProxyElementParser(cacheModelParser);
        this.registerInterceptorsElementParser(cacheModelParser);
    }

    protected abstract CacheModelParser getCacheModelParser();

    protected abstract BeanDefinitionParser getCacheProviderFacadeParser();

    private void registerAnnotationsElementParser(CacheModelParser cacheModelParser) {
        if (SystemUtils.atLeastJ2SE5()) {
            String thisPackage = (class$org$springmodules$cache$config$AbstractCacheNamespaceHandler == null ? (class$org$springmodules$cache$config$AbstractCacheNamespaceHandler = AbstractCacheNamespaceHandler.class$("org.springmodules.cache.config.AbstractCacheNamespaceHandler")) : class$org$springmodules$cache$config$AbstractCacheNamespaceHandler).getPackage().getName();
            String annotationsParserClassName = thisPackage + ".AnnotationsParser";
            try {
                Class parserClass = ClassUtils.forName((String)annotationsParserClassName);
                Object parser = parserClass.newInstance();
                this.registerCacheSetupStrategyParser("annotations", (AbstractCacheSetupStrategyParser)parser, cacheModelParser);
            }
            catch (Exception exception) {
                String errorMessage = "Unable to create instance of " + annotationsParserClassName + ". Unable to load parser for namespace 'annotations'";
                throw new FatalCacheException(errorMessage, exception);
            }
        } else {
            this.logger.info((Object)"No support for JDK 1.5 Annotations. Unable to load parser for namespace 'annotations'");
        }
    }

    private void registerCacheSetupStrategyParser(String elementName, AbstractCacheSetupStrategyParser parser, CacheModelParser cacheModelParser) {
        parser.setCacheModelParser(cacheModelParser);
        this.registerBeanDefinitionParser(elementName, parser);
    }

    private void registerCommonsAttributesElementParser(CacheModelParser cacheModelParser) {
        CommonsAttributesParser parser = new CommonsAttributesParser();
        this.registerCacheSetupStrategyParser("commons-attributes", parser, cacheModelParser);
    }

    private void registerInterceptorsElementParser(CacheModelParser cacheModelParser) {
        MethodMapInterceptorsParser parser = new MethodMapInterceptorsParser();
        this.registerCacheSetupStrategyParser("methodMapInterceptors", parser, cacheModelParser);
    }

    private void registerProxyElementParser(CacheModelParser cacheModelParser) {
        CacheProxyFactoryBeanParser parser = new CacheProxyFactoryBeanParser();
        this.registerCacheSetupStrategyParser("proxy", parser, cacheModelParser);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

