/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor.flush;

import java.beans.PropertyEditor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;
import org.springmodules.cache.FatalCacheException;
import org.springmodules.cache.FlushingModel;
import org.springmodules.cache.provider.CacheModelValidator;
import org.springmodules.cache.provider.CacheProviderFacade;

public abstract class AbstractFlushingInterceptor
implements MethodInterceptor,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CacheProviderFacade cacheProviderFacade;
    private Map flushingModels;

    public final void afterPropertiesSet() throws FatalCacheException {
        if (this.cacheProviderFacade == null) {
            throw new FatalCacheException("The cache provider facade should not be null");
        }
        if (this.flushingModels == null || this.flushingModels.isEmpty()) {
            return;
        }
        CacheModelValidator validator = this.cacheProviderFacade.modelValidator();
        if (this.flushingModels instanceof Properties) {
            PropertyEditor editor = this.cacheProviderFacade.getFlushingModelEditor();
            Properties properties = (Properties)this.flushingModels;
            HashMap<String, Object> newFlushingModels = new HashMap<String, Object>();
            String id = null;
            try {
                Iterator<Object> i = properties.keySet().iterator();
                while (i.hasNext()) {
                    id = (String)i.next();
                    String property = properties.getProperty(id);
                    editor.setAsText(property);
                    Object flushingModel = editor.getValue();
                    validator.validateFlushingModel(flushingModel);
                    newFlushingModels.put(id, flushingModel);
                }
            }
            catch (Exception exception) {
                throw new FatalCacheException("Unable to create the flushing model with id " + StringUtils.quote((String)id), exception);
            }
            this.setFlushingModels(newFlushingModels);
        } else {
            String id = null;
            try {
                Iterator i = this.flushingModels.keySet().iterator();
                while (i.hasNext()) {
                    id = (String)i.next();
                    Object flushingModel = this.flushingModels.get(id);
                    validator.validateFlushingModel(flushingModel);
                }
            }
            catch (Exception exception) {
                throw new FatalCacheException("Unable to validate flushing model with id " + StringUtils.quote(id), exception);
            }
        }
        this.onAfterPropertiesSet();
    }

    public final Object invoke(MethodInvocation methodInvocation) throws Throwable {
        FlushingModel model = this.getModel(methodInvocation);
        if (null == model) {
            this.logger.info((Object)"Unable to flush cache. No model is associated to the intercepted method");
            return methodInvocation.proceed();
        }
        Object proceedReturnValue = null;
        if (model.flushBeforeMethodExecution()) {
            this.cacheProviderFacade.flushCache(model);
            proceedReturnValue = methodInvocation.proceed();
        } else {
            proceedReturnValue = methodInvocation.proceed();
            this.cacheProviderFacade.flushCache(model);
        }
        return proceedReturnValue;
    }

    public final void setCacheProviderFacade(CacheProviderFacade newCacheProviderFacade) {
        this.cacheProviderFacade = newCacheProviderFacade;
    }

    public final void setFlushingModels(Map newFlushingModels) {
        this.flushingModels = newFlushingModels;
    }

    protected final Map getFlushingModels() {
        return this.flushingModels;
    }

    protected abstract FlushingModel getModel(MethodInvocation var1);

    protected void onAfterPropertiesSet() throws FatalCacheException {
    }
}

