/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.springframework.util.ReflectionUtils;
import org.springmodules.util.Objects;

public abstract class Reflections {
    private static final int INITIAL_HASH = 7;
    private static final int MULTIPLIER = 31;

    public static int reflectionHashCode(Object obj) {
        Class<?> targetClass;
        if (obj == null) {
            return 0;
        }
        if (Objects.isArrayOfPrimitives(obj) || Objects.isPrimitiveOrWrapper(targetClass)) {
            return Objects.nullSafeHashCode(obj);
        }
        if (targetClass.isArray()) {
            return Reflections.reflectionHashCode((Object[])obj);
        }
        if (obj instanceof Collection) {
            return Reflections.reflectionHashCode((Collection)obj);
        }
        if (obj instanceof Map) {
            return Reflections.reflectionHashCode((Map)obj);
        }
        Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        Method hashCodeMethod = ReflectionUtils.findMethod(clazz, (String)"hashCode", (Class[])new Class[0]);
        if (hashCodeMethod != null) {
            return obj.hashCode();
        }
        int hash = 7;
        try {
            for (targetClass = obj.getClass(); targetClass != null; targetClass = targetClass.getSuperclass()) {
                AccessibleObject[] fields = targetClass.getDeclaredFields();
                AccessibleObject.setAccessible(fields, true);
                for (int i = 0; i < fields.length; ++i) {
                    AccessibleObject field = fields[i];
                    int modifiers = ((Field)field).getModifiers();
                    if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                    hash = 31 * hash + Reflections.reflectionHashCode(((Field)field).get(obj));
                }
            }
        }
        catch (IllegalAccessException exception) {
            ReflectionUtils.handleReflectionException((Exception)exception);
        }
        return hash;
    }

    private static int reflectionHashCode(Collection collection) {
        int hash = 7;
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            hash = 31 * hash + Reflections.reflectionHashCode(i.next());
        }
        return hash;
    }

    private static int reflectionHashCode(Map map) {
        int hash = 7;
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            hash = 31 * hash + Reflections.reflectionHashCode(entry);
        }
        return hash;
    }

    private static int reflectionHashCode(Map.Entry entry) {
        int hash = 7;
        hash = 31 * hash + Reflections.reflectionHashCode(entry.getKey());
        hash = 31 * hash + Reflections.reflectionHashCode(entry.getValue());
        return hash;
    }

    private static int reflectionHashCode(Object[] array) {
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + Reflections.reflectionHashCode(array[i]);
        }
        return hash;
    }
}

