/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.markup.html.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.NonI18nPalette;
import org.apache.syncope.client.ui.commons.markup.html.form.SelectChoiceRenderer;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.string.Strings;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class AjaxPalettePanel<T extends Serializable>
extends AbstractFieldPanel<List<T>> {
    private static final long serialVersionUID = 7738499668258805567L;
    protected Palette<T> palette;
    protected final Model<String> queryFilter = new Model((Serializable)((Object)""));
    protected final List<T> availableBefore = new ArrayList<T>();
    private final LoadableDetachableModel<List<T>> choicesModel;

    public AjaxPalettePanel(String id, IModel<List<T>> model, final Builder.Query<T> query, Builder<T> builder) {
        super(id, builder.name == null ? id : builder.name, model);
        this.choicesModel = new PaletteLoadableDetachableModel(builder){
            private static final long serialVersionUID = -108100712154481840L;

            @Override
            protected List<T> getChoices() {
                return query.execute((String)((Object)AjaxPalettePanel.this.queryFilter.getObject()));
            }
        };
        this.initialize(model, builder);
    }

    public AjaxPalettePanel(String id, IModel<List<T>> model, final IModel<List<T>> choices, Builder<T> builder) {
        super(id, builder.name == null ? id : builder.name, model);
        this.choicesModel = new PaletteLoadableDetachableModel(builder){
            private static final long serialVersionUID = -108100712154481840L;

            @Override
            protected List<T> getChoices() {
                return this.builder.filtered ? this.getFilteredList((Collection)choices.getObject(), ((String)((Object)AjaxPalettePanel.this.queryFilter.getObject())).replaceAll("\\*", "\\.\\*")) : (List)choices.getObject();
            }
        };
        this.initialize(model, builder);
    }

    protected void initialize(IModel<List<T>> model, final Builder<T> builder) {
        this.setOutputMarkupId(true);
        this.palette = this.buildPalette(model, builder);
        this.add(new Component[]{this.palette.setLabel((IModel)new ResourceModel(this.name)).setOutputMarkupId(true)});
        Form form = new Form("form");
        this.add(new Component[]{form.setEnabled(builder.filtered).setVisible(builder.filtered)});
        this.queryFilter.setObject((Serializable)((Object)builder.filter));
        AjaxTextFieldPanel filter = new AjaxTextFieldPanel("filter", "filter", (IModel<String>)this.queryFilter, false);
        form.add(new Component[]{filter.hideLabel().setOutputMarkupId(true)});
        AjaxButton search = new AjaxButton("search"){
            private static final long serialVersionUID = 8390605330558248736L;

            protected void onSubmit(AjaxRequestTarget target) {
                if (builder.warnIfEmptyFilter && StringUtils.isEmpty((CharSequence)((CharSequence)((Object)AjaxPalettePanel.this.queryFilter.getObject())))) {
                    Session.get().info((Serializable)((Object)this.getString("nomatch")));
                    ((BaseWebPage)this.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                }
                target.add(new Component[]{AjaxPalettePanel.this.palette});
            }
        };
        search.setOutputMarkupId(true);
        form.add(new Component[]{search});
    }

    protected Palette<T> buildPalette(IModel<List<T>> model, final Builder<T> builder) {
        return new NonI18nPalette<T>("paletteField", (IModel)model, (IModel)this.choicesModel, builder.renderer, 8, builder.allowOrder, builder.allowMoveAll){
            private static final long serialVersionUID = -3074655279011678437L;

            protected Component newAvailableHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("palette.available", builder.availableLabel));
            }

            protected Component newSelectedHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("palette.selected", builder.selectedLabel));
            }

            protected Recorder<T> newRecorderComponent() {
                Recorder recorder = new Recorder<T>("recorder", this){
                    private static final long serialVersionUID = -9169109967480083523L;

                    public List<T> getUnselectedList() {
                        IChoiceRenderer renderer = this.getChoiceRenderer();
                        Collection choices = this.getChoices();
                        List ids = ((Stream)builder.idExtractor.apply((Object)this.getValue())).collect(Collectors.toList());
                        ArrayList unselected = new ArrayList(choices.size());
                        choices.forEach(choice -> {
                            if (!ids.contains(renderer.getIdValue(choice, 0))) {
                                unselected.add(choice);
                            }
                        });
                        return unselected;
                    }

                    public List<T> getSelectedList() {
                        IChoiceRenderer renderer = this.getChoiceRenderer();
                        Collection choices = this.getChoices();
                        Map idForChoice = choices.stream().collect(Collectors.toMap(Function.identity(), choice -> renderer.getIdValue(choice, 0), (c1, c2) -> c1));
                        ArrayList selected = new ArrayList(choices.size());
                        ((Stream)builder.idExtractor.apply((Object)this.getValue())).forEach(id -> {
                            for (Serializable choice : choices) {
                                if (!id.equals(idForChoice.get(choice))) continue;
                                selected.add(choice);
                                break;
                            }
                        });
                        return selected;
                    }
                };
                recorder.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                    private static final long serialVersionUID = -6139318907146065915L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        this.processInput();
                        Optional.ofNullable(builder.event).ifPresent(e -> e.apply((Object)target));
                    }
                }});
                return recorder;
            }

            @Override
            protected Map<String, String> getAdditionalAttributes(Object choice) {
                return builder.additionalAttributes == null ? super.getAdditionalAttributes(choice) : (Map)builder.additionalAttributes.apply(choice);
            }
        };
    }

    public Recorder<T> getRecorderComponent() {
        return this.palette.getRecorderComponent();
    }

    public LoadableDetachableModel<List<T>> getChoicesModel() {
        return this.choicesModel;
    }

    @Override
    public AjaxPalettePanel<T> setModelObject(List<T> object) {
        this.palette.setDefaultModelObject(object);
        return this;
    }

    public Collection<T> getModelCollection() {
        return this.palette.getModelCollection();
    }

    public void reload(AjaxRequestTarget target) {
        target.add(new Component[]{this.palette});
    }

    @Override
    public AbstractFieldPanel<List<T>> setReadOnly(boolean readOnly) {
        this.palette.setEnabled(!readOnly);
        return this;
    }

    @Override
    public AbstractFieldPanel<List<T>> setRequired(boolean required) {
        this.palette.setRequired(required);
        return super.setRequired(required);
    }

    public static class UpdateActionEvent {
        private final UserTO item;
        private final AjaxRequestTarget target;

        public UpdateActionEvent(UserTO item, AjaxRequestTarget target) {
            this.item = item;
            this.target = target;
        }

        public UserTO getItem() {
            return this.item;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }
    }

    protected abstract class PaletteLoadableDetachableModel
    extends LoadableDetachableModel<List<T>> {
        private static final long serialVersionUID = -7745220313769774616L;
        protected final Builder<T> builder;

        public PaletteLoadableDetachableModel(Builder<T> builder) {
            this.builder = builder;
        }

        protected abstract List<T> getChoices();

        protected List<T> load() {
            List<Object> selected = AjaxPalettePanel.this.availableBefore.isEmpty() ? new ArrayList(AjaxPalettePanel.this.palette.getModelCollection()) : this.getSelectedList(AjaxPalettePanel.this.availableBefore);
            AjaxPalettePanel.this.availableBefore.clear();
            AjaxPalettePanel.this.availableBefore.addAll(ListUtils.sum(selected, this.getChoices()));
            return AjaxPalettePanel.this.availableBefore;
        }

        protected List<T> getSelectedList(Collection<T> choices) {
            IChoiceRenderer renderer = AjaxPalettePanel.this.palette.getChoiceRenderer();
            Map idForChoice = choices.stream().collect(Collectors.toMap(Function.identity(), choice -> renderer.getIdValue(choice, 0), (c1, c2) -> c1));
            ArrayList selected = new ArrayList();
            ((Stream)this.builder.idExtractor.apply((Object)AjaxPalettePanel.this.palette.getRecorderComponent().getValue())).forEach(id -> {
                Iterator iter = choices.iterator();
                boolean found = false;
                while (!found && iter.hasNext()) {
                    Serializable choice = (Serializable)iter.next();
                    if (!id.equals(idForChoice.get(choice))) continue;
                    selected.add(choice);
                    found = true;
                }
            });
            return selected;
        }

        protected List<T> getFilteredList(Collection<T> choices, String filter) {
            IChoiceRenderer renderer = AjaxPalettePanel.this.palette.getChoiceRenderer();
            Map idForChoice = choices.stream().collect(Collectors.toMap(Function.identity(), choice -> renderer.getIdValue(choice, 0), (c1, c2) -> c1));
            Pattern pattern = Pattern.compile(filter, 2);
            return choices.stream().filter(choice -> pattern.matcher((CharSequence)idForChoice.get(choice)).matches()).collect(Collectors.toList());
        }
    }

    public static class Builder<T extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = 991248996001040352L;
        protected String name;
        protected IChoiceRenderer<T> renderer = new SelectChoiceRenderer();
        protected boolean allowOrder;
        protected boolean allowMoveAll;
        protected String selectedLabel;
        protected String availableLabel;
        protected boolean filtered;
        protected String filter = "*";
        protected boolean warnIfEmptyFilter = true;
        protected SerializableFunction<String, Stream<String>> idExtractor = (SerializableFunction & Serializable)input -> Stream.of(Strings.split((String)input, (char)','));
        protected SerializableFunction<AjaxRequestTarget, Boolean> event;
        protected SerializableFunction<Object, Map<String, String>> additionalAttributes;

        public Builder<T> setName(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> setAllowOrder(boolean allowOrder) {
            this.allowOrder = allowOrder;
            return this;
        }

        public Builder<T> setAllowMoveAll(boolean allowMoveAll) {
            this.allowMoveAll = allowMoveAll;
            return this;
        }

        public Builder<T> setSelectedLabel(String selectedLabel) {
            this.selectedLabel = selectedLabel;
            return this;
        }

        public Builder<T> setAvailableLabel(String availableLabel) {
            this.availableLabel = availableLabel;
            return this;
        }

        public Builder<T> setRenderer(IChoiceRenderer<T> renderer) {
            this.renderer = renderer;
            return this;
        }

        public Builder<T> withFilter() {
            this.filtered = true;
            return this;
        }

        public Builder<T> withFilter(String defaultFilter) {
            this.filtered = true;
            this.filter = defaultFilter;
            return this;
        }

        public Builder<T> warnIfEmptyFilter(boolean warnIfEmptyFilter) {
            this.warnIfEmptyFilter = warnIfEmptyFilter;
            return this;
        }

        public Builder<T> idExtractor(SerializableFunction<String, Stream<String>> idExtractor) {
            this.idExtractor = idExtractor;
            return this;
        }

        public Builder<T> event(SerializableFunction<AjaxRequestTarget, Boolean> event) {
            this.event = event;
            return this;
        }

        public Builder<T> additionalAttributes(SerializableFunction<Object, Map<String, String>> additionalAttributes) {
            this.additionalAttributes = additionalAttributes;
            return this;
        }

        public AjaxPalettePanel<T> build(String id, IModel<List<T>> model, IModel<List<T>> choices) {
            return new AjaxPalettePanel<T>(id, model, choices, this);
        }

        public AjaxPalettePanel<T> build(String id, IModel<List<T>> model, Query<T> choices) {
            return new AjaxPalettePanel<T>(id, model, choices, this);
        }

        public static abstract class Query<T extends Serializable>
        implements Serializable {
            private static final long serialVersionUID = 3582312993557742858L;

            public abstract List<T> execute(String var1);
        }
    }
}

