/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.commons;

import java.io.Serializable;
import java.util.UUID;
import org.apache.wicket.Component;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.ActionPermissions;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public abstract class ITabComponent
extends Component
implements ITab {
    private static final long serialVersionUID = -6908617525434875508L;
    private final IModel<String> title;

    public ITabComponent(IModel<String> title, String ... roles) {
        super(UUID.randomUUID().toString());
        this.title = title;
        ActionPermissions permissions = new ActionPermissions();
        this.setMetaData(MetaDataRoleAuthorizationStrategy.ACTION_PERMISSIONS, (Serializable)permissions);
        if (roles == null || roles.length == 0) {
            permissions.authorizeAll(RENDER);
        } else {
            permissions.authorize(RENDER, new Roles(roles));
        }
    }

    public IModel<String> getTitle() {
        return this.title;
    }

    public boolean isVisible() {
        return true;
    }

    protected void onRender() {
        this.internalRenderComponent();
    }

    public abstract WebMarkupContainer getPanel(String var1);
}

