/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.notifications;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.commons.TemplateContent;
import org.apache.syncope.client.console.notifications.TemplateModal;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.NotificationRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.XMLEditorPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.panels.WizardModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AbstractModalPanelBuilder;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.MailTemplateTO;
import org.apache.syncope.common.lib.types.MailTemplateFormat;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class MailTemplateDirectoryPanel
extends DirectoryPanel<MailTemplateTO, MailTemplateTO, MailTemplateProvider, NotificationRestClient> {
    private static final long serialVersionUID = -3789392431954221446L;
    protected final BaseModal<String> utilityModal = new BaseModal("outer");

    public MailTemplateDirectoryPanel(String id, final NotificationRestClient restClient, PageReference pageRef) {
        super(id, restClient, pageRef, true);
        this.disableCheckBoxes();
        this.modal.size(Modal.Size.Small);
        this.modal.addSubmitButton();
        this.setWindowClosedReloadCallback(this.modal, true);
        this.setFooterVisibility(true);
        this.addOuterObject(new Component[]{this.utilityModal});
        this.setWindowClosedReloadCallback(this.utilityModal);
        this.utilityModal.size(Modal.Size.Large);
        this.utilityModal.addSubmitButton();
        this.addNewItemPanelBuilder(new AbstractModalPanelBuilder<MailTemplateTO>(new MailTemplateTO(), pageRef){
            private static final long serialVersionUID = 1995192603527154740L;

            public WizardModalPanel<MailTemplateTO> build(String id, int index, AjaxWizard.Mode mode) {
                return new TemplateModal(MailTemplateDirectoryPanel.this.modal, restClient, new MailTemplateTO(), this.pageRef);
            }
        }, true);
        this.initResultTable();
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"MAIL_TEMPLATE_CREATE");
    }

    @Override
    protected List<IColumn<MailTemplateTO, String>> getColumns() {
        ArrayList<IColumn<MailTemplateTO, String>> columns = new ArrayList<IColumn<MailTemplateTO, String>>();
        columns.add((IColumn<MailTemplateTO, String>)new PropertyColumn((IModel)new StringResourceModel("key", (Component)this), (Object)"key", "key"));
        return columns;
    }

    @Override
    public ActionsPanel<MailTemplateTO> getActions(final IModel<MailTemplateTO> model) {
        ActionsPanel<MailTemplateTO> panel = super.getActions(model);
        panel.add(new ActionLink<MailTemplateTO>(){
            private static final long serialVersionUID = -7978723352517770645L;

            @Override
            public void onClick(AjaxRequestTarget target, MailTemplateTO ignore) {
                TemplateContent<MailTemplateFormat> content = new TemplateContent<MailTemplateFormat>(((MailTemplateTO)model.getObject()).getKey(), MailTemplateFormat.HTML);
                content.setContent(((NotificationRestClient)MailTemplateDirectoryPanel.this.restClient).readTemplateFormat(((MailTemplateTO)model.getObject()).getKey(), MailTemplateFormat.HTML));
                MailTemplateDirectoryPanel.this.utilityModal.header((IModel)new ResourceModel("mail.template.html", "HTML Content"));
                MailTemplateDirectoryPanel.this.utilityModal.setContent((ModalPanel)new TemplateContentEditorPanel(content, MailTemplateDirectoryPanel.this.pageRef));
                MailTemplateDirectoryPanel.this.utilityModal.show(true);
                target.add(new Component[]{MailTemplateDirectoryPanel.this.utilityModal});
            }
        }, ActionLink.ActionType.HTML, "MAIL_TEMPLATE_UPDATE");
        panel.add(new ActionLink<MailTemplateTO>(){
            private static final long serialVersionUID = -7978723352517770645L;

            @Override
            public void onClick(AjaxRequestTarget target, MailTemplateTO ignore) {
                TemplateContent<MailTemplateFormat> content = new TemplateContent<MailTemplateFormat>(((MailTemplateTO)model.getObject()).getKey(), MailTemplateFormat.TEXT);
                content.setContent(((NotificationRestClient)MailTemplateDirectoryPanel.this.restClient).readTemplateFormat(((MailTemplateTO)model.getObject()).getKey(), MailTemplateFormat.TEXT));
                MailTemplateDirectoryPanel.this.utilityModal.header((IModel)new ResourceModel("mail.template.text", "TEXT Content"));
                MailTemplateDirectoryPanel.this.utilityModal.setContent((ModalPanel)new TemplateContentEditorPanel(content, MailTemplateDirectoryPanel.this.pageRef));
                MailTemplateDirectoryPanel.this.utilityModal.show(true);
                target.add(new Component[]{MailTemplateDirectoryPanel.this.utilityModal});
            }
        }, ActionLink.ActionType.TEXT, "MAIL_TEMPLATE_UPDATE");
        panel.add(new ActionLink<MailTemplateTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, MailTemplateTO ignore) {
                try {
                    ((NotificationRestClient)MailTemplateDirectoryPanel.this.restClient).deleteTemplate(((MailTemplateTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)MailTemplateDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{MailTemplateDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting object {}", (Object)((MailTemplateTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)MailTemplateDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "MAIL_TEMPLATE_DELETE", true);
        return panel;
    }

    @Override
    protected MailTemplateProvider dataProvider() {
        return new MailTemplateProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "mail.template.paginator.rows";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    private class TemplateContentEditorPanel
    extends XMLEditorPanel {
        private static final long serialVersionUID = -3528875878627216097L;
        private final TemplateContent<MailTemplateFormat> content;

        TemplateContentEditorPanel(TemplateContent<MailTemplateFormat> content, PageReference pageRef) {
            super(MailTemplateDirectoryPanel.this.utilityModal, (IModel<String>)new PropertyModel(content, "content"), false, pageRef);
            this.content = content;
        }

        @Override
        public void onSubmit(AjaxRequestTarget target) {
            if (StringUtils.isBlank((CharSequence)this.content.getContent())) {
                SyncopeConsoleSession.get().error((Serializable)((Object)"No content to save"));
            } else {
                try {
                    ((NotificationRestClient)MailTemplateDirectoryPanel.this.restClient).updateTemplateFormat(this.content.getKey(), this.content.getContent(), this.content.getFormat());
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                    this.modal.show(false);
                    this.modal.close((IPartialPageRequestHandler)target);
                }
                catch (Exception e) {
                    LOG.error("While updating template for {}", (Object)this.content.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException(e);
                }
            }
            ((BaseWebPage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
    }

    protected final class MailTemplateProvider
    extends DirectoryDataProvider<MailTemplateTO> {
        private static final long serialVersionUID = -276043813563988590L;
        private final SortableDataProviderComparator<MailTemplateTO> comparator;

        public MailTemplateProvider(int paginatorRows) {
            super(paginatorRows);
            this.comparator = new SortableDataProviderComparator<MailTemplateTO>(this);
        }

        public Iterator<MailTemplateTO> iterator(long first, long count) {
            List<MailTemplateTO> templates = ((NotificationRestClient)MailTemplateDirectoryPanel.this.restClient).listTemplates();
            templates.sort(this.comparator);
            return templates.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((NotificationRestClient)MailTemplateDirectoryPanel.this.restClient).listTemplates().size();
        }

        public IModel<MailTemplateTO> model(final MailTemplateTO mailTemplateTO) {
            return new IModel<MailTemplateTO>(){
                private static final long serialVersionUID = 774694801558497248L;

                public MailTemplateTO getObject() {
                    return mailTemplateTO;
                }
            };
        }
    }
}

