/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.sort;

import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortState;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.util.lang.Args;

public class OrderByLink<S>
extends Link<Void> {
    private static final long serialVersionUID = 1L;
    private final S property;
    private final ISortStateLocator<S> stateLocator;

    public OrderByLink(String id, S property, ISortStateLocator<S> stateLocator) {
        super(id);
        Args.notNull(property, (String)"property");
        this.property = property;
        this.stateLocator = stateLocator;
    }

    public final void onClick() {
        this.sort();
        this.onSortChanged();
    }

    protected void onSortChanged() {
    }

    public final OrderByLink<S> sort() {
        if (this.isVersioned()) {
            this.addStateChange();
        }
        ISortState<S> state = this.stateLocator.getSortState();
        SortOrder order = state.getPropertySortOrder(this.property);
        state.setPropertySortOrder(this.property, this.nextSortOrder(order));
        return this;
    }

    protected SortOrder nextSortOrder(SortOrder order) {
        if (order == SortOrder.NONE) {
            return SortOrder.ASCENDING;
        }
        return order == SortOrder.ASCENDING ? SortOrder.DESCENDING : SortOrder.ASCENDING;
    }
}

