/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.jwks;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyStoreUtils;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.rotation.OidcJsonWebKeystoreRotationService;
import org.apereo.cas.oidc.web.controllers.BaseOidcController;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

public class OidcJwksEndpointController
extends BaseOidcController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcJwksEndpointController.class);
    private final OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService;

    public OidcJwksEndpointController(OidcConfigurationContext configurationContext, OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService) {
        super(configurationContext);
        this.oidcJsonWebKeystoreGeneratorService = oidcJsonWebKeystoreGeneratorService;
    }

    @GetMapping(value={"/oidc/jwks", "/**/jwks"}, produces={"application/json"})
    @Operation(summary="Produces the collection of keys from the keystore", parameters={@Parameter(name="state", description="Filter keys by their state name", required=false)})
    public ResponseEntity<String> handleRequestInternal(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="state", required=false) String state) {
        JEEContext webContext = new JEEContext(request, response);
        if (!((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().validateIssuer((WebContext)webContext, "jwks")) {
            String body = OAuth20Utils.toJson((Object)OAuth20Utils.getErrorResponseBody((String)"invalid_request", (String)"Invalid issuer"));
            return new ResponseEntity((Object)body, HttpStatus.BAD_REQUEST);
        }
        try {
            Resource resource = this.oidcJsonWebKeystoreGeneratorService.generate();
            String jsonJwks = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
            JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(jsonJwks);
            ServicesManager servicesManager = ((OidcConfigurationContext)this.getConfigurationContext()).getServicesManager();
            servicesManager.getAllServicesOfType(OidcRegisteredService.class).stream().filter(s -> {
                String serviceJwks = SpringExpressionLanguageValueResolver.getInstance().resolve(s.getJwks());
                return StringUtils.isNotBlank((CharSequence)serviceJwks);
            }).forEach(service -> {
                Optional<JsonWebKeySet> set = OidcJsonWebKeyStoreUtils.getJsonWebKeySet(service, (ResourceLoader)((OidcConfigurationContext)this.getConfigurationContext()).getApplicationContext(), Optional.empty());
                set.ifPresent(keys -> keys.getJsonWebKeys().forEach(arg_0 -> ((JsonWebKeySet)jsonWebKeySet).addJsonWebKey(arg_0)));
            });
            if (StringUtils.isNotBlank((CharSequence)state)) {
                jsonWebKeySet.getJsonWebKeys().removeIf(key -> {
                    String st = OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.getJsonWebKeyState(key).name();
                    return !state.equalsIgnoreCase(st);
                });
            }
            String body = jsonWebKeySet.toJson(JsonWebKey.OutputControlLevel.PUBLIC_ONLY);
            response.setContentType("application/json");
            return new ResponseEntity((Object)body, HttpStatus.OK);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return new ResponseEntity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage()), HttpStatus.BAD_REQUEST);
        }
    }
}

