/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.audit.AuditEntry;
import org.apache.syncope.common.lib.audit.EventCategory;
import org.apache.syncope.common.lib.to.AuditConfTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.logic.AbstractLogic;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.logic.audit.AuditAppender;
import org.apache.syncope.core.logic.init.AuditLoader;
import org.apache.syncope.core.persistence.api.dao.AuditConfDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.AuditConf;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.ImplementationLookup;
import org.apache.syncope.core.provisioning.api.data.AuditDataBinder;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

public class AuditLogic
extends AbstractTransactionalLogic<AuditConfTO> {
    protected static final List<EventCategory> EVENTS = new ArrayList<EventCategory>();
    protected final AuditConfDAO auditConfDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final EntityFactory entityFactory;
    protected final ImplementationLookup implementationLookup;
    protected final AuditDataBinder binder;
    protected final AuditManager auditManager;
    protected final List<AuditAppender> auditAppenders;
    protected final LoggingSystem loggingSystem;

    public AuditLogic(AuditConfDAO auditConfDAO, ExternalResourceDAO resourceDAO, EntityFactory entityFactory, ImplementationLookup implementationLookup, AuditDataBinder binder, AuditManager auditManager, List<AuditAppender> auditAppenders, LoggingSystem loggingSystem) {
        this.auditConfDAO = auditConfDAO;
        this.resourceDAO = resourceDAO;
        this.entityFactory = entityFactory;
        this.implementationLookup = implementationLookup;
        this.binder = binder;
        this.auditManager = auditManager;
        this.auditAppenders = auditAppenders;
        this.loggingSystem = loggingSystem;
    }

    @PreAuthorize(value="hasRole('AUDIT_LIST')")
    @Transactional(readOnly=true)
    public List<AuditConfTO> list() {
        return this.auditConfDAO.findAll().stream().map(arg_0 -> ((AuditDataBinder)this.binder).getAuditTO(arg_0)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('AUDIT_READ')")
    @Transactional(readOnly=true)
    public AuditConfTO read(String key) {
        return Optional.ofNullable(this.auditConfDAO.find(key)).map(arg_0 -> ((AuditDataBinder)this.binder).getAuditTO(arg_0)).orElseThrow(() -> new NotFoundException("Audit " + key));
    }

    @PreAuthorize(value="hasRole('AUDIT_SET')")
    public void set(AuditConfTO auditTO) {
        AuditConf audit = Optional.ofNullable(this.auditConfDAO.find(auditTO.getKey())).orElseGet(() -> {
            AuditConf ac = (AuditConf)this.entityFactory.newEntity(AuditConf.class);
            ac.setKey(auditTO.getKey());
            return ac;
        });
        audit.setActive(auditTO.isActive());
        audit = this.auditConfDAO.save(audit);
        this.setLevel(audit.getKey(), audit.isActive() ? LogLevel.DEBUG : LogLevel.OFF);
    }

    @PreAuthorize(value="hasRole('AUDIT_DELETE')")
    public void delete(String key) {
        AuditConf audit = Optional.ofNullable(this.auditConfDAO.find(key)).orElseThrow(() -> new NotFoundException("Audit " + key));
        this.auditConfDAO.delete(audit);
        this.setLevel(audit.getKey(), LogLevel.OFF);
    }

    protected void setLevel(String key, LogLevel level) {
        String auditLoggerName = AuditLoggerName.getAuditEventLoggerName((String)AuthContextUtils.getDomain(), (String)key);
        LoggerContext logCtx = (LoggerContext)LogManager.getContext((boolean)false);
        LoggerConfig logConf = logCtx.getConfiguration().getLoggerConfig(auditLoggerName);
        this.auditAppenders.stream().filter(appender -> appender.getEvents().stream().anyMatch(event -> key.equalsIgnoreCase(event.toAuditKey()))).forEach(auditAppender -> AuditLoader.addAppenderToLoggerContext(logCtx, auditAppender, logConf));
        this.loggingSystem.setLogLevel(auditLoggerName, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="hasRole('AUDIT_LIST') or hasRole('NOTIFICATION_LIST')")
    public List<EventCategory> events() {
        List<EventCategory> list = EVENTS;
        synchronized (list) {
            if (!EVENTS.isEmpty()) {
                return EVENTS;
            }
        }
        HashSet<EventCategory> events = new HashSet<EventCategory>();
        EventCategory authenticationEventCategory = new EventCategory();
        authenticationEventCategory.setCategory("Authentication");
        authenticationEventCategory.getEvents().add("login");
        events.add(authenticationEventCategory);
        this.implementationLookup.getClassNames("TASKJOB_DELEGATE").forEach(clazz -> {
            EventCategory eventCategory = new EventCategory(AuditElements.EventCategoryType.TASK);
            eventCategory.setCategory(StringUtils.substringAfterLast((String)clazz, (int)46));
            events.add(eventCategory);
        });
        events.add(new EventCategory(AuditElements.EventCategoryType.WA));
        events.add(new EventCategory(AuditElements.EventCategoryType.CUSTOM));
        try {
            Resource[] resources;
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
            CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
            String packageSearchPath = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)this.getClass().getPackage().getName())) + "/**/*.class";
            for (Resource resource : resources = resourcePatternResolver.getResources(packageSearchPath)) {
                MetadataReader metadataReader;
                Class<?> clazz2;
                if (!resource.isReadable() || !AbstractLogic.class.isAssignableFrom(clazz2 = Class.forName((metadataReader = metadataReaderFactory.getMetadataReader(resource)).getClassMetadata().getClassName()))) continue;
                EventCategory eventCategory = new EventCategory();
                eventCategory.setCategory(clazz2.getSimpleName());
                for (Method method : clazz2.getDeclaredMethods()) {
                    if (!Modifier.isPublic(method.getModifiers()) || eventCategory.getEvents().contains(method.getName())) continue;
                    eventCategory.getEvents().add(method.getName());
                }
                events.add(eventCategory);
            }
            for (Resource resource : AnyTypeKind.values()) {
                this.resourceDAO.findAll().forEach(arg_0 -> AuditLogic.lambda$events$7((AnyTypeKind)resource, events, arg_0));
            }
        }
        catch (Exception e) {
            LOG.error("Failure retrieving audit/notification events", (Throwable)e);
        }
        EVENTS.addAll(events);
        return EVENTS;
    }

    @PreAuthorize(value="hasRole('AUDIT_SEARCH')")
    @Transactional(readOnly=true)
    public Pair<Integer, List<AuditEntry>> search(String entityKey, int page, int size, AuditElements.EventCategoryType type, String category, String subcategory, List<String> events, AuditElements.Result result, OffsetDateTime before, OffsetDateTime after, List<OrderByClause> orderBy) {
        int count = this.auditConfDAO.countEntries(entityKey, type, category, subcategory, events, result, before, after);
        List matching = this.auditConfDAO.searchEntries(entityKey, page, size, type, category, subcategory, events, result, before, after, orderBy);
        return Pair.of((Object)count, (Object)matching);
    }

    @PreAuthorize(value="isAuthenticated()")
    public void create(AuditEntry auditEntry) {
        boolean authorized;
        boolean bl = authorized = AuthContextUtils.getAuthorizations().containsKey("AUDIT_SET") || AuthContextUtils.getAuthorizations().containsKey("ANONYMOUS") && AuditElements.EventCategoryType.WA == auditEntry.getLogger().getType();
        if (!authorized) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.DelegatedAdministration);
            sce.getElements().add("Not allowed to create Audit entries");
            throw sce;
        }
        this.auditManager.audit(auditEntry.getWho(), auditEntry.getLogger().getType(), auditEntry.getLogger().getCategory(), auditEntry.getLogger().getSubcategory(), auditEntry.getLogger().getEvent(), auditEntry.getLogger().getResult(), (Object)auditEntry.getBefore(), (Object)auditEntry.getOutput(), new Object[]{auditEntry.getInputs()});
    }

    @Override
    protected AuditConfTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof AuditConfTO)) continue;
                key = ((AuditConfTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getAuditTO(this.auditConfDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }

    private static /* synthetic */ void lambda$events$7(AnyTypeKind anyTypeKind, Set events, ExternalResource resource) {
        String event;
        EventCategory propEventCategory = new EventCategory(AuditElements.EventCategoryType.PROPAGATION);
        EventCategory pullEventCategory = new EventCategory(AuditElements.EventCategoryType.PULL);
        EventCategory pushEventCategory = new EventCategory(AuditElements.EventCategoryType.PUSH);
        propEventCategory.setCategory(anyTypeKind.name());
        propEventCategory.setSubcategory(resource.getKey());
        pullEventCategory.setCategory(anyTypeKind.name());
        pushEventCategory.setCategory(anyTypeKind.name());
        pullEventCategory.setSubcategory(resource.getKey());
        pushEventCategory.setSubcategory(resource.getKey());
        for (ResourceOperation resourceOperation : ResourceOperation.values()) {
            propEventCategory.getEvents().add(resourceOperation.name().toLowerCase());
        }
        pullEventCategory.getEvents().add(ResourceOperation.DELETE.name().toLowerCase());
        for (ResourceOperation resourceOperation : UnmatchingRule.values()) {
            event = UnmatchingRule.toEventName((UnmatchingRule)resourceOperation);
            pullEventCategory.getEvents().add(event);
            pushEventCategory.getEvents().add(event);
        }
        for (ResourceOperation resourceOperation : MatchingRule.values()) {
            event = MatchingRule.toEventName((MatchingRule)resourceOperation);
            pullEventCategory.getEvents().add(event);
            pushEventCategory.getEvents().add(event);
        }
        events.add(propEventCategory);
        events.add(pullEventCategory);
        events.add(pushEventCategory);
    }
}

