/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValueHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.IsStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.IsStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class IsStepPlaceholder<S>
extends FilterStep<S>
implements GValueHolder<S, S>,
IsStepContract<S> {
    private P<S> predicate;

    public IsStepPlaceholder(Traversal.Admin traversal, P<S> predicate) {
        super(traversal);
        this.predicate = predicate;
        traversal.getGValueManager().register(predicate.getGValues());
    }

    @Override
    protected boolean filter(Traverser.Admin<S> traverser) {
        throw new IllegalStateException("IsStepPlaceholder is not executable");
    }

    @Override
    public P<S> getPredicate() {
        if (this.predicate.isParameterized()) {
            this.traversal.getGValueManager().pinGValues((Collection<GValue<?>>)this.predicate.getGValues());
        }
        return this.predicate;
    }

    @Override
    public P<S> getPredicateGValueSafe() {
        return this.predicate;
    }

    @Override
    public IsStepPlaceholder<S> clone() {
        IsStepPlaceholder clone = (IsStepPlaceholder)super.clone();
        clone.predicate = this.predicate.clone();
        return clone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IsStepPlaceholder that = (IsStepPlaceholder)o;
        return Objects.equals(this.predicate, that.predicate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.predicate);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return EnumSet.of(TraverserRequirement.OBJECT);
    }

    public IsStep<S> asConcreteStep() {
        IsStep<S> step = new IsStep<S>(this.traversal, this.predicate);
        TraversalHelper.copyLabels(this, step, false);
        return step;
    }

    @Override
    public boolean isParameterized() {
        return this.predicate.isParameterized();
    }

    @Override
    public void updateVariable(String name, Object value) {
        this.predicate.updateVariable(name, value);
    }

    @Override
    public Collection<GValue<?>> getGValues() {
        return this.predicate.getGValues();
    }
}

