/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.swizzle.stream;

import java.io.IOException;
import java.io.InputStream;
import org.tomitribe.swizzle.stream.FilteredInputStream;
import org.tomitribe.swizzle.stream.ScanBuffer;
import org.tomitribe.swizzle.stream.State;

public class IncludeFilterInputStream
extends FilteredInputStream {
    private final ScanBuffer beginBuffer;
    private final ScanBuffer endBuffer;
    protected State state;
    private boolean keepDelimiters;
    protected final State findBegin = new State(){

        @Override
        public int read() throws IOException {
            int b;
            while ((b = IncludeFilterInputStream.this.super$read()) != -1) {
                IncludeFilterInputStream.this.beginBuffer.append(b);
                if (!IncludeFilterInputStream.this.beginBuffer.match()) continue;
                if (IncludeFilterInputStream.this.keepDelimiters) {
                    IncludeFilterInputStream.this.state = IncludeFilterInputStream.this.flushBeginToken;
                } else {
                    IncludeFilterInputStream.this.beginBuffer.flush();
                    IncludeFilterInputStream.this.state = IncludeFilterInputStream.this.findEnd;
                }
                return IncludeFilterInputStream.this.state.read();
            }
            return -1;
        }
    };
    protected final State flushBeginToken = new State(){

        @Override
        public int read() throws IOException {
            int flushed = IncludeFilterInputStream.this.beginBuffer.append(-1);
            if (flushed != -1) {
                return flushed;
            }
            IncludeFilterInputStream.this.state = IncludeFilterInputStream.this.findEnd;
            return IncludeFilterInputStream.this.state.read();
        }
    };
    protected final State findEnd = new State(){

        @Override
        public int read() throws IOException {
            int b;
            int a = b = IncludeFilterInputStream.this.super$read();
            b = IncludeFilterInputStream.this.endBuffer.append(b);
            if (b == -1 && a == -1) {
                return -1;
            }
            if (IncludeFilterInputStream.this.endBuffer.match()) {
                if (IncludeFilterInputStream.this.keepDelimiters) {
                    IncludeFilterInputStream.this.state = IncludeFilterInputStream.this.flushEndToken;
                } else {
                    IncludeFilterInputStream.this.endBuffer.flush();
                    IncludeFilterInputStream.this.state = IncludeFilterInputStream.this.findBegin;
                }
            }
            return b == -1 ? IncludeFilterInputStream.this.state.read() : b;
        }
    };
    protected final State flushEndToken = new State(){

        @Override
        public int read() throws IOException {
            int flushed = IncludeFilterInputStream.this.endBuffer.append(-1);
            if (flushed != -1) {
                return flushed;
            }
            IncludeFilterInputStream.this.state = IncludeFilterInputStream.this.findBegin;
            return IncludeFilterInputStream.this.state.read();
        }
    };

    public IncludeFilterInputStream(InputStream in, String begin, String end) {
        this(in, begin, end, true);
    }

    public IncludeFilterInputStream(InputStream in, String begin, String end, boolean caseSensitive) {
        this(in, begin, end, caseSensitive, true);
    }

    public IncludeFilterInputStream(InputStream in, String begin, String end, boolean caseSensitive, boolean keepDelimiters) {
        super(in);
        this.beginBuffer = new ScanBuffer(begin, caseSensitive);
        this.endBuffer = new ScanBuffer(end, caseSensitive);
        this.keepDelimiters = keepDelimiters;
        this.state = this.findBegin;
    }

    @Override
    public int read() throws IOException {
        return this.state.read();
    }

    private int super$read() throws IOException {
        return super.read();
    }
}

