/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.openejb.jee.oejb2;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for service-completionType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="service-completionType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="service-name" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="port-completion" type="{http://geronimo.apache.org/xml/ns/naming-1.2}port-completionType" maxOccurs="unbounded"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "service-completionType", namespace = "http://geronimo.apache.org/xml/ns/naming-1.2", propOrder = {
    "serviceName",
    "portCompletion"
})
public class ServiceCompletionType {

    @XmlElement(name = "service-name", required = true)
    protected String serviceName;
    @XmlElement(name = "port-completion", required = true)
    protected List<PortCompletionType> portCompletion;

    /**
     * Gets the value of the serviceName property.
     *
     * @return possible object is
     * {@link String }
     */
    public String getServiceName() {
        return serviceName;
    }

    /**
     * Sets the value of the serviceName property.
     *
     * @param value allowed object is
     *              {@link String }
     */
    public void setServiceName(final String value) {
        this.serviceName = value;
    }

    /**
     * Gets the value of the portCompletion property.
     *
     *
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the portCompletion property.
     *
     *
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPortCompletion().add(newItem);
     * </pre>
     *
     *
     *
     * Objects of the following type(s) are allowed in the list
     * {@link PortCompletionType }
     */
    public List<PortCompletionType> getPortCompletion() {
        if (portCompletion == null) {
            portCompletion = new ArrayList<PortCompletionType>();
        }
        return this.portCompletion;
    }

}
