/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaProcessRuntimeException;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.rule.AnnotationComparator;
import org.apache.uima.ruta.rule.ComposedRuleElement;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementComparator;
import org.apache.uima.ruta.rule.RuleElementMatch;

public class ComposedRuleElementMatch
extends RuleElementMatch {
    private Map<RuleElement, List<RuleElementMatch>> innerMatches;
    private boolean textsMatchedUpdated = false;

    public ComposedRuleElementMatch(ComposedRuleElement ruleElement, ComposedRuleElementMatch containerMatch) {
        super(ruleElement, containerMatch);
        this.baseConditionMatched = false;
        ComposedRuleElement cre = ruleElement;
        this.innerMatches = new TreeMap<RuleElement, List<RuleElementMatch>>(new RuleElementComparator(cre));
        List<RuleElement> ruleElements = cre.getRuleElements();
        for (RuleElement eachRuleElement : ruleElements) {
            this.innerMatches.put(eachRuleElement, null);
        }
    }

    protected void enforceUpdate() {
        this.textsMatchedUpdated = false;
        ComposedRuleElementMatch cm = this.getContainerMatch();
        if (cm != null) {
            cm.enforceUpdate();
        }
    }

    private void setInnerMatches(Map<RuleElement, List<RuleElementMatch>> innerMatches) {
        this.innerMatches = innerMatches;
        this.enforceUpdate();
    }

    public Map<RuleElement, List<RuleElementMatch>> getInnerMatches() {
        return this.innerMatches;
    }

    public void addInnerMatch(RuleElement ruleElement, RuleElementMatch ruleElementMatch, RutaStream stream) {
        this.addInnerMatch(ruleElement, ruleElementMatch, true, stream);
    }

    public void addInnerMatch(RuleElement ruleElement, RuleElementMatch ruleElementMatch, boolean included, RutaStream stream) {
        List<RuleElementMatch> list = this.innerMatches.get(ruleElement);
        if (list == null) {
            list = new ArrayList<RuleElementMatch>();
            this.innerMatches.put(ruleElement, list);
        }
        list.add(ruleElementMatch);
        if ((long)list.size() > stream.getMaxRuleElementMatches()) {
            throw new RutaProcessRuntimeException("Rule element exceeded the allowed amount of matches (" + stream.getMaxRuleElementMatches() + "): " + ruleElement.toString());
        }
        this.evaluateInnerMatches(included, stream);
        this.enforceUpdate();
    }

    public void evaluateInnerMatches(boolean included, RutaStream stream) {
        boolean allDone = true;
        boolean oneDone = false;
        Set<Map.Entry<RuleElement, List<RuleElementMatch>>> entrySet = this.innerMatches.entrySet();
        for (Map.Entry<RuleElement, List<RuleElementMatch>> entry : entrySet) {
            RuleElement element = entry.getKey();
            List<RuleElementMatch> value = entry.getValue();
            MatchContext context = new MatchContext(element, null, true);
            allDone &= element.getQuantifier().isOptional(context, stream) || value != null;
            if (value == null || value.isEmpty() || !included) continue;
            for (RuleElementMatch ruleElementMatch : value) {
                allDone &= ruleElementMatch.matched();
                oneDone |= ruleElementMatch.matched();
            }
        }
        ComposedRuleElement cre = (ComposedRuleElement)this.ruleElement;
        this.baseConditionMatched = cre.getConjunct() != null && cre.getConjunct() == false ? oneDone : allDone;
    }

    @Override
    public ComposedRuleElementMatch copy() {
        ComposedRuleElementMatch copy = new ComposedRuleElementMatch((ComposedRuleElement)this.ruleElement, this.containerMatch);
        copy.setBaseConditionMatched(this.baseConditionMatched);
        copy.setConditions(this.conditions);
        copy.setConditionsMatched(this.conditionsMatched);
        copy.setTextsMatched(this.textsMatched);
        TreeMap<RuleElement, List<RuleElementMatch>> newMap = new TreeMap<RuleElement, List<RuleElementMatch>>(new RuleElementComparator((ComposedRuleElement)this.ruleElement));
        for (Map.Entry<RuleElement, List<RuleElementMatch>> entry : this.innerMatches.entrySet()) {
            List<RuleElementMatch> value = entry.getValue();
            if (value != null) {
                ArrayList<RuleElementMatch> newValue = new ArrayList<RuleElementMatch>();
                for (RuleElementMatch each : value) {
                    newValue.add(each.copy());
                }
                newMap.put(entry.getKey(), newValue);
                continue;
            }
            newMap.put(entry.getKey(), null);
        }
        copy.setInnerMatches(newMap);
        return copy;
    }

    public ComposedRuleElementMatch copy(ComposedRuleElementMatch extendedContainerMatch, boolean after) {
        ComposedRuleElementMatch copy = new ComposedRuleElementMatch((ComposedRuleElement)this.ruleElement, this.containerMatch);
        copy.setBaseConditionMatched(this.baseConditionMatched);
        copy.setConditions(this.conditions);
        copy.setConditionsMatched(this.conditionsMatched);
        copy.setTextsMatched(this.textsMatched);
        TreeMap<RuleElement, List<RuleElementMatch>> newMap = new TreeMap<RuleElement, List<RuleElementMatch>>(new RuleElementComparator((ComposedRuleElement)this.ruleElement));
        for (Map.Entry<RuleElement, List<RuleElementMatch>> entry : this.innerMatches.entrySet()) {
            ArrayList<RuleElementMatch> newValue;
            RuleElement key = entry.getKey();
            List<RuleElementMatch> value = entry.getValue();
            if (key.equals(extendedContainerMatch.getRuleElement())) {
                extendedContainerMatch.setContainerMatch(copy);
                if (value == null) continue;
                newValue = new ArrayList();
                newValue.addAll(value);
                newValue.set(newValue.size() - 1, extendedContainerMatch);
                newMap.put(extendedContainerMatch.getRuleElement(), newValue);
                continue;
            }
            if (value != null) {
                newValue = new ArrayList<RuleElementMatch>();
                for (RuleElementMatch each : value) {
                    each.setContainerMatch(copy);
                    if (each instanceof ComposedRuleElementMatch) {
                        newValue.add(((ComposedRuleElementMatch)each).copy(extendedContainerMatch, after));
                        continue;
                    }
                    newValue.add(each.copy());
                }
                newMap.put(entry.getKey(), newValue);
                continue;
            }
            newMap.put(entry.getKey(), null);
        }
        copy.setInnerMatches(newMap);
        return copy;
    }

    public ComposedRuleElementMatch copy2(ComposedRuleElementMatch extendedContainerMatch, boolean after) {
        ComposedRuleElementMatch copy = new ComposedRuleElementMatch((ComposedRuleElement)this.ruleElement, this.containerMatch);
        copy.setBaseConditionMatched(this.baseConditionMatched);
        copy.setConditions(this.conditions);
        copy.setConditionsMatched(this.conditionsMatched);
        copy.setTextsMatched(this.textsMatched);
        TreeMap<RuleElement, List<RuleElementMatch>> newMap = new TreeMap<RuleElement, List<RuleElementMatch>>(new RuleElementComparator((ComposedRuleElement)this.ruleElement));
        for (Map.Entry<RuleElement, List<RuleElementMatch>> entry : this.innerMatches.entrySet()) {
            ArrayList<RuleElementMatch> newValue;
            RuleElement key = entry.getKey();
            List<RuleElementMatch> value = entry.getValue();
            if (key.equals(extendedContainerMatch.getRuleElement())) {
                extendedContainerMatch.setContainerMatch(copy);
                if (value == null) continue;
                newValue = new ArrayList<RuleElementMatch>();
                newValue.addAll(value);
                if (!newValue.isEmpty()) {
                    newValue.set(newValue.size() - 1, extendedContainerMatch);
                }
                newMap.put(extendedContainerMatch.getRuleElement(), newValue);
                continue;
            }
            if (value != null && !value.isEmpty()) {
                newValue = new ArrayList();
                int counter = 0;
                for (RuleElementMatch each : value) {
                    each.setContainerMatch(copy);
                    boolean isCurrentOne = false;
                    if (counter == value.size() - 1) {
                        isCurrentOne = true;
                    }
                    if (each instanceof ComposedRuleElementMatch && isCurrentOne) {
                        newValue.add(((ComposedRuleElementMatch)each).copy2(extendedContainerMatch, after));
                    } else {
                        newValue.add(each.copy());
                    }
                    ++counter;
                }
                newMap.put(entry.getKey(), newValue);
                continue;
            }
            newMap.put(entry.getKey(), null);
        }
        copy.setInnerMatches(newMap);
        return copy;
    }

    public void update(ComposedRuleElementMatch extendedContainerMatch) {
        for (Map.Entry<RuleElement, List<RuleElementMatch>> entry : this.innerMatches.entrySet()) {
            RuleElement key = entry.getKey();
            List<RuleElementMatch> value = entry.getValue();
            if (key.equals(extendedContainerMatch.getRuleElement())) {
                extendedContainerMatch.setContainerMatch(this);
                if (value == null) continue;
                value.set(value.size() - 1, extendedContainerMatch);
                continue;
            }
            if (value == null) continue;
            for (RuleElementMatch each : value) {
                if (!(each instanceof ComposedRuleElementMatch)) continue;
                ((ComposedRuleElementMatch)each).update(extendedContainerMatch);
            }
        }
        this.enforceUpdate();
    }

    @Override
    public String toString() {
        return "CREM" + this.innerMatches.toString();
    }

    @Override
    public List<AnnotationFS> getTextsMatched() {
        if (!this.textsMatchedUpdated || this.textsMatched == null) {
            TreeSet<AnnotationFS> set = new TreeSet<AnnotationFS>(new AnnotationComparator());
            Collection<List<RuleElementMatch>> values = this.innerMatches.values();
            for (List<RuleElementMatch> list : values) {
                if (list == null) continue;
                for (RuleElementMatch ruleElementMatch : list) {
                    set.addAll(ruleElementMatch.getTextsMatched());
                }
            }
            this.textsMatched = new ArrayList<AnnotationFS>(set);
            this.textsMatchedUpdated = true;
        }
        return this.textsMatched;
    }

    public void setConditionInfo(List<EvaluatedCondition> evaluatedConditions) {
        this.conditions = evaluatedConditions;
        for (EvaluatedCondition each : this.conditions) {
            this.conditionsMatched = this.conditionsMatched && each.isValue();
        }
    }
}

