/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.customvalidators;

import com.sun.enterprise.config.serverbeans.customvalidators.ReferenceConstraint;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.UnexpectedTypeException;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Dom;

public class ReferenceValidator
implements ConstraintValidator<ReferenceConstraint, ConfigBeanProxy> {
    static final LocalStringManagerImpl LOCAL_STRINGS = new LocalStringManagerImpl(ReferenceValidator.class);
    private ReferenceConstraint rc;

    public void initialize(ReferenceConstraint rc) {
        this.rc = rc;
    }

    public boolean isValid(ConfigBeanProxy config, ConstraintValidatorContext cvc) throws UnexpectedTypeException {
        if (config == null) {
            return true;
        }
        Dom dom = Dom.unwrap((ConfigBeanProxy)config);
        if (this.rc.skipDuringCreation() && dom.getKey() == null) {
            return true;
        }
        Collection<RemoteKeyInfo> remoteKeys = this.findRemoteKeys(config);
        if (!remoteKeys.isEmpty()) {
            ServiceLocator habitat = dom.getHabitat();
            boolean result = true;
            boolean disableGlobalMessage = true;
            for (RemoteKeyInfo remoteKeyInfo : remoteKeys) {
                if (remoteKeyInfo.method.getParameterTypes().length > 0) {
                    throw new UnexpectedTypeException(LOCAL_STRINGS.getLocalString("referenceValidator.not.getter", "The RemoteKey annotation must be on a getter method."));
                }
                try {
                    Object value = remoteKeyInfo.method.invoke((Object)config, new Object[0]);
                    if (value instanceof String) {
                        String key = (String)value;
                        ConfigBeanProxy component = (ConfigBeanProxy)habitat.getService(remoteKeyInfo.annotation.type(), key, new Annotation[0]);
                        if (component != null) continue;
                        result = false;
                        if (remoteKeyInfo.annotation.message().isEmpty()) {
                            disableGlobalMessage = false;
                            continue;
                        }
                        cvc.buildConstraintViolationWithTemplate(remoteKeyInfo.annotation.message()).addNode(Dom.convertName((String)remoteKeyInfo.method.getName())).addConstraintViolation();
                        continue;
                    }
                    throw new UnexpectedTypeException(LOCAL_STRINGS.getLocalString("referenceValidator.not.string", "The RemoteKey annotation must identify a method that returns a String."));
                }
                catch (Exception ex) {
                    return false;
                }
            }
            if (!result && disableGlobalMessage) {
                cvc.disableDefaultConstraintViolation();
            }
            return result;
        }
        return true;
    }

    private Collection<RemoteKeyInfo> findRemoteKeys(Object o) {
        ArrayList<RemoteKeyInfo> result = new ArrayList<RemoteKeyInfo>();
        if (o == null) {
            return Collections.emptyList();
        }
        this.findRemoteKeys(o.getClass(), result);
        return result;
    }

    private void findRemoteKeys(Class c, Collection<RemoteKeyInfo> result) {
        Class<?>[] interfaces;
        Method[] methods;
        for (Method method : methods = c.getMethods()) {
            ReferenceConstraint.RemoteKey annotation = method.getAnnotation(ReferenceConstraint.RemoteKey.class);
            if (annotation == null) continue;
            result.add(new RemoteKeyInfo(method, annotation));
        }
        Class superclass = c.getSuperclass();
        if (superclass != null) {
            this.findRemoteKeys(superclass, result);
        }
        for (Class<?> iface : interfaces = c.getInterfaces()) {
            this.findRemoteKeys(iface, result);
        }
    }

    static class RemoteKeyInfo {
        final Method method;
        final ReferenceConstraint.RemoteKey annotation;

        public RemoteKeyInfo(Method method, ReferenceConstraint.RemoteKey annotation) {
            this.method = method;
            this.annotation = annotation;
        }
    }
}

