/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.model;

import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

public class Message {
    private Severity severity;
    private String field;
    private String message;

    public Message(Severity severity, String message) {
        this.severity = severity;
        this.message = message;
    }

    public Message(Severity severity, String field, String message) {
        this.severity = severity;
        this.field = field;
        this.message = message;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity val) {
        this.severity = val;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String val) {
        this.message = val;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String val) {
        this.field = val;
    }

    public JsonObject toJson() throws JsonException {
        JsonObjectBuilder object = Json.createObjectBuilder();
        object.add("message", this.getMessage());
        object.add("severity", this.getSeverity().toString());
        String f = this.getField();
        if (f != null && f.length() > 0) {
            object.add("field", f);
        }
        return object.build();
    }

    public static enum Severity {
        SUCCESS,
        WARNING,
        FAILURE;

    }
}

