/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.util.JDK;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.resources.AbstractResource;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionFailure;

@Produces(value={"text/html", "application/json", "application/xml", "application/x-www-form-urlencoded"})
public abstract class CollectionLeafResource
extends AbstractResource {
    protected List<String> entity;
    protected Dom parent;
    protected String tagName;
    protected String target;
    protected String profiler = "false";
    protected boolean isJvmOptions = false;
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CollectionLeafResource.class);
    private static final String MIN_VERSION = "minVersion";
    private static final String MAX_VERISON = "maxVersion";
    private static final String VENDOR = "vendor";
    private static final String JVM_OPTION = "jvmOption";

    public void setEntity(List<String> p) {
        this.entity = p;
    }

    public List<String> getEntity() {
        return this.entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentAndTagName(Dom parent, String tagName) {
        this.parent = parent;
        this.tagName = tagName;
        if (parent != null) {
            Dom dom = parent;
            synchronized (dom) {
                if (parent.getImplementationClass().equals(JavaConfig.class) && this.isJvmOptions(tagName)) {
                    JavaConfig javaConfig = (JavaConfig)parent.get();
                    this.entity = javaConfig != null ? javaConfig.getJvmRawOptions() : parent.leafElements(tagName);
                    this.isJvmOptions = true;
                } else {
                    this.entity = parent.leafElements(tagName);
                }
            }
            if (parent.getImplementationClass().equals(JavaConfig.class)) {
                this.target = parent.parent().attribute("name");
            } else {
                this.target = parent.parent().parent().attribute("name");
                this.profiler = "true";
            }
        }
    }

    @GET
    public Response get(@QueryParam(value="expandLevel") @DefaultValue(value="1") int expandLevel) {
        if (this.getEntity() == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return Response.ok(this.buildActionReportResult()).build();
    }

    @POST
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public Response create(HashMap<String, String> data) throws TransactionFailure {
        if (data.containsKey("operation") && data.get("operation").equals("__deleteoperation")) {
            data.remove("operation");
            return this.delete(data);
        }
        String postCommand = this.getPostCommand();
        Map<String, String> payload = null;
        Map<String, String> existing = null;
        if (this.isJvmOptions(postCommand)) {
            existing = this.deleteExistingOptions();
            payload = this.processData(data, false);
        } else {
            payload = data;
        }
        Response response = this.runCommand(postCommand, payload, "rest.resource.create.message", "\"{0}\" created successfully.", "rest.resource.post.forbidden", "POST on \"{0}\" is forbidden.");
        if (response.getStatus() != 200) {
            payload = this.processData(existing, false);
            this.runCommand(postCommand, payload, "rest.resource.create.message", "\"{0}\" created successfully.", "rest.resource.post.forbidden", "POST on \"{0}\" is forbidden.");
        }
        return response;
    }

    @PUT
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Deprecated
    public Response add(HashMap<String, String> data) throws TransactionFailure {
        String postCommand = this.getPostCommand();
        Map<String, String> payload = null;
        payload = this.isJvmOptions(postCommand) ? this.processData(data, false) : data;
        return this.runCommand(postCommand, payload, "rest.resource.create.message", "\"{0}\" created successfully.", "rest.resource.post.forbidden", "POST on \"{0}\" is forbidden.");
    }

    @DELETE
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public Response delete(HashMap<String, String> data) {
        if (data == null) {
            data = new HashMap();
        }
        ResourceUtil.addQueryString(this.uriInfo.getQueryParameters(), data);
        String deleteCommand = this.getDeleteCommand();
        if (this.isJvmOptions(deleteCommand)) {
            if (data.isEmpty()) {
                this.deleteExistingOptions();
                return Response.ok().build();
            }
            return this.runCommand(deleteCommand, this.processData(data, true), "rest.resource.delete.message", "\"{0}\" deleted successfully.", "rest.resource.delete.forbidden", "DELETE on \"{0}\" is forbidden.");
        }
        return this.runCommand(deleteCommand, data, "rest.resource.delete.message", "\"{0}\" deleted successfully.", "rest.resource.delete.forbidden", "DELETE on \"{0}\" is forbidden.");
    }

    @OPTIONS
    @Produces(value={"text/html", "application/json", "application/xml"})
    public Response options() {
        return Response.ok(this.buildActionReportResult()).build();
    }

    protected ActionReportResult buildActionReportResult() {
        RestActionReporter ar = new RestActionReporter();
        String typeKey = Util.upperCaseFirstLetter(Util.decode(this.getName()));
        ar.setActionDescription(typeKey);
        if (this.isJvmOptions) {
            List<String> optionsEntity = this.getEntity();
            ArrayList<Map<String, String>> optionsList = new ArrayList<Map<String, String>>(optionsEntity.size());
            for (String option : optionsEntity) {
                MiniXmlParser.JvmOption jvmOption = new MiniXmlParser.JvmOption(option);
                optionsList.add(this.optionToMap(jvmOption));
            }
            ar.getExtraProperties().put("leafList", optionsList);
        } else {
            ar.getExtraProperties().put("leafList", this.getEntity());
        }
        OptionsResult optionsResult = new OptionsResult(Util.getResourceName(this.uriInfo));
        Map<String, MethodMetaData> mmd = this.getMethodMetaData();
        optionsResult.putMethodMetaData("GET", mmd.get("GET"));
        optionsResult.putMethodMetaData("POST", mmd.get("POST"));
        ResourceUtil.addMethodMetaData((ActionReport)ar, mmd);
        return new ActionReportResult(ar, optionsResult);
    }

    private Map<String, String> optionToMap(MiniXmlParser.JvmOption option) {
        HashMap<String, String> baseMap = new HashMap<String, String>();
        if (option.vendor.isPresent()) {
            baseMap.put(MIN_VERSION, (String)option.vendor.get() + "-" + option.minVersion.map(JDK.Version::toString).orElse(""));
        } else {
            baseMap.put(MIN_VERSION, option.minVersion.map(JDK.Version::toString).orElse(""));
        }
        baseMap.put(MAX_VERISON, option.maxVersion.map(JDK.Version::toString).orElse(""));
        baseMap.put(JVM_OPTION, option.option);
        return Collections.unmodifiableMap(baseMap);
    }

    protected Map<String, MethodMetaData> getMethodMetaData() {
        String deleteCommand;
        TreeMap<String, MethodMetaData> mmd = new TreeMap<String, MethodMetaData>();
        mmd.put("GET", new MethodMetaData());
        String postCommand = this.getPostCommand();
        if (postCommand != null) {
            MethodMetaData postMethodMetaData = ResourceUtil.getMethodMetaData(postCommand, this.locatorBridge.getRemoteLocator());
            mmd.put("POST", postMethodMetaData);
        }
        if ((deleteCommand = this.getDeleteCommand()) != null) {
            MethodMetaData deleteMethodMetaData = ResourceUtil.getMethodMetaData(deleteCommand, this.locatorBridge.getRemoteLocator());
            mmd.put("DELETE", deleteMethodMetaData);
        }
        return mmd;
    }

    protected void addDefaultParameter(Map<String, String> data) {
        int index = this.uriInfo.getAbsolutePath().getPath().lastIndexOf(47);
        String defaultParameterValue = this.uriInfo.getAbsolutePath().getPath().substring(index + 1);
        data.put("DEFAULT", defaultParameterValue);
    }

    protected String getPostCommand() {
        return null;
    }

    protected String getDeleteCommand() {
        return null;
    }

    protected String getName() {
        return Util.getResourceName(this.uriInfo);
    }

    private Response runCommand(String commandName, Map<String, String> data, String successMsgKey, String successMsg, String operationForbiddenMsgKey, String operationForbiddenMsg) {
        try {
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                return Response.status(400).entity(ResourceUtil.getActionReportResult(ActionReport.ExitCode.FAILURE, errorMessage, this.requestHeaders, this.uriInfo)).build();
            }
            ResourceUtil.purgeEmptyEntries(data);
            ResourceUtil.adjustParameters(data);
            String attributeName = data.get("DEFAULT");
            if (null != commandName) {
                RestActionReporter actionReport = ResourceUtil.runCommand(commandName, data, this.getSubject());
                ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
                if (exitCode != ActionReport.ExitCode.FAILURE) {
                    String successMessage = localStrings.getLocalString(successMsgKey, successMsg, new Object[]{attributeName});
                    return Response.ok(ResourceUtil.getActionReportResult(actionReport, successMessage, this.requestHeaders, this.uriInfo)).build();
                }
                String errorMessage = this.getErrorMessage(data, (ActionReport)actionReport);
                return Response.status(400).entity(ResourceUtil.getActionReportResult(actionReport, errorMessage, this.requestHeaders, this.uriInfo)).build();
            }
            String message = localStrings.getLocalString(operationForbiddenMsgKey, operationForbiddenMsg, new Object[]{this.uriInfo.getAbsolutePath()});
            return Response.status(403).entity(ResourceUtil.getActionReportResult(ActionReport.ExitCode.FAILURE, message, this.requestHeaders, this.uriInfo)).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String getErrorMessage(Map<String, String> data, ActionReport ar) {
        String message = ar.getMessage();
        return message;
    }

    protected Map<String, String> processData(Map<String, String> data, boolean removeVersioning) {
        Map<String, String> results = ResourceUtil.processJvmOptions(data, removeVersioning);
        if (results.get("target") == null) {
            results.put("target", this.target);
        }
        if (results.get("profiler") == null) {
            results.put("profiler", this.profiler);
        }
        return results;
    }

    protected String escapeOptionPart(String part) {
        return part.replace("\\", "\\\\").replace(":", "\\:");
    }

    private boolean isJvmOptions(String command) {
        return command != null && command.contains("jvm-options");
    }

    protected Map<String, String> deleteExistingOptions() {
        HashMap<String, String> existing = new HashMap<String, String>();
        existing.put("target", this.target);
        for (String option : this.getEntity()) {
            int index = option.indexOf(61);
            if (index > -1) {
                existing.put(this.escapeOptionPart(option.substring(0, index)), this.escapeOptionPart(option.substring(index + 1)));
                continue;
            }
            existing.put(this.escapeOptionPart(option), "");
        }
        this.runCommand(this.getDeleteCommand(), this.processData(existing, true), "rest.resource.delete.message", "\"{0}\" deleted successfully.", "rest.resource.delete.forbidden", "DELETE on \"{0}\" is forbidden.");
        return existing;
    }
}

