/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.custom;

import com.sun.enterprise.server.logging.logviewer.backend.LogFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.admin.rest.logviewer.CharSpool;
import org.glassfish.admin.rest.logviewer.LineEndNormalizingWriter;
import org.glassfish.admin.rest.resources.custom.LogViewerResource;

public class NotificationLogViewer
extends LogViewerResource {
    private static final Logger logger = Logger.getLogger("NotificationLogViewer");
    List<String> fileBody = new ArrayList<String>();
    private LogViewerResource.Source source;

    @Override
    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    public Response get(@QueryParam(value="start") @DefaultValue(value="0") long start, @QueryParam(value="instanceName") @DefaultValue(value="server") String instanceName, @Context HttpHeaders hh) throws IOException {
        CharSpool spool;
        long size;
        boolean gzipOK = true;
        MultivaluedMap<String, String> headerParams = hh.getRequestHeaders();
        String acceptEncoding = headerParams.getFirst("Accept-Encoding");
        if (acceptEncoding == null || !acceptEncoding.contains("gzip")) {
            gzipOK = false;
        }
        LogFilter logFilter = (LogFilter)this.habitat.getRemoteLocator().getService(LogFilter.class, new Annotation[0]);
        String logLocation = logFilter.getLogFileForGivenTarget(instanceName);
        this.readServerLogFile(logLocation);
        String logFolderLocation = logLocation.replace("server.log", "");
        String notificationFolderLocation = logFolderLocation + File.separator + "notificationLogs";
        this.createNotificationLogFolder(notificationFolderLocation);
        String notificationLogLocation = notificationFolderLocation + File.separator + "notification.log";
        this.writeToNotificationLogFile(notificationLogLocation);
        this.initLargeText(new File(notificationLogLocation), false);
        if (!this.source.exists()) {
            UriBuilder uriBuilder = this.ui.getAbsolutePathBuilder();
            uriBuilder.queryParam("start", 0);
            uriBuilder.queryParam("instanceName", instanceName);
            return Response.ok(new StreamingOutput(){

                @Override
                public void write(OutputStream out) throws IOException, WebApplicationException {
                }
            }).header("X-Text-Append-Next", uriBuilder.build(new Object[0])).build();
        }
        if (this.source.length() < start) {
            start = 0L;
        }
        if ((size = this.writeLogTo(start, spool = new CharSpool())) < 10000L) {
            gzipOK = false;
        }
        final boolean gz = gzipOK;
        Response.ResponseBuilder rp = Response.ok(new StreamingOutput(){

            @Override
            public void write(OutputStream out) throws IOException, WebApplicationException {
                Writer w = NotificationLogViewer.this.getWriter(out, gz);
                spool.writeTo(new LineEndNormalizingWriter(w));
                w.flush();
                w.close();
            }
        });
        UriBuilder uriBuilder = this.ui.getAbsolutePathBuilder();
        uriBuilder.queryParam("start", size);
        uriBuilder.queryParam("instanceName", instanceName);
        URI next = uriBuilder.build(new Object[0]);
        rp.header("X-Text-Append-Next", next);
        if (gzipOK) {
            rp = rp.header("Content-Encoding", "gzip");
        }
        return rp.build();
    }

    private Writer getWriter(OutputStream out, boolean gzipOK) throws IOException {
        if (!gzipOK) {
            return new OutputStreamWriter(out);
        }
        return new OutputStreamWriter((OutputStream)new GZIPOutputStream(out), "UTF-8");
    }

    public void createNotificationLogFolder(String FolderName) {
        File notificationFolder = new File(FolderName);
        if (!notificationFolder.exists()) {
            if (notificationFolder.mkdir()) {
                logger.log(Level.INFO, "Notification Folder was created on " + FolderName);
            } else {
                logger.log(Level.SEVERE, "Failed to create Notification Folder");
            }
        }
    }

    public void writeToNotificationLogFile(String fileName) {
        try (PrintWriter pw = new PrintWriter(new FileOutputStream(fileName));){
            for (String text : this.fileBody) {
                if (text.contains("WARNING") || text.contains("SEVERE") || text.contains("FINE") || text.contains("CONFIG") || text.contains("INFO")) {
                    pw.println("\n" + text);
                    continue;
                }
                pw.println(text);
            }
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public void readServerLogFile(String file) {
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String sCurrentLine;
            while ((sCurrentLine = br.readLine()) != null) {
                if (!sCurrentLine.contains("LogNotifierService") && !sCurrentLine.contains("RequestEvent") && !sCurrentLine.contains("ServletRequestEvent") && !sCurrentLine.contains("conversationId") && !sCurrentLine.contains("elapsedTime") && !sCurrentLine.contains("user-agent") && !sCurrentLine.contains("requestTracing") && !sCurrentLine.contains("alarmType")) continue;
                this.fileBody.add(sCurrentLine);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }
}

