/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.jaspic;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class ContextAuthenticationMechanismMapping {
    private static final ContextAuthenticationMechanismMapping INSTANCE = new ContextAuthenticationMechanismMapping();
    private Map<String, String> mapping = new HashMap<String, String>();

    private ContextAuthenticationMechanismMapping() {
    }

    public void registerAuthenticationMechanism(ServletContext servletContext) {
        String parameter = servletContext.getInitParameter("fish.payara.security.mechanism");
        String contextPath = servletContext.getContextPath();
        this.mapping.put(contextPath, parameter);
    }

    public static ContextAuthenticationMechanismMapping getInstance() {
        return INSTANCE;
    }

    public String getMechanism(HttpServletRequest request) {
        String result = null;
        String requestURI = request.getRequestURI();
        for (Map.Entry<String, String> entry : this.mapping.entrySet()) {
            if (!requestURI.startsWith(entry.getKey())) continue;
            result = entry.getValue();
        }
        return result;
    }
}

