/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.util;

import org.glassfish.weld.ACLSingletonProvider;
import org.jboss.weld.bootstrap.api.SingletonProvider;

public class Util {
    public static <T> T newInstance(String className) {
        try {
            return Util.classForName(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate instance of " + className + " with no-argument constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot instantiate instance of " + className + " with no-argument constructor", e);
        }
    }

    public static <T> Class<T> classForName(String name) {
        try {
            Class<?> c;
            if (Thread.currentThread().getContextClassLoader() != null) {
                Class<?> c2;
                Class<?> clazz = c2 = Thread.currentThread().getContextClassLoader().loadClass(name);
                return clazz;
            }
            Class<?> clazz = c = Class.forName(name);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot load class for " + name, e);
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalArgumentException("Cannot load class for " + name, e);
        }
    }

    public static void initializeWeldSingletonProvider() {
        SingletonProvider.initialize((SingletonProvider)new ACLSingletonProvider());
    }
}

