/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.gf.ejb.internal;

import javax.annotation.PostConstruct;
import javax.interceptor.InvocationContext;
import org.glassfish.jersey.internal.inject.InjectionManager;

public final class EjbComponentInterceptor {
    private final InjectionManager injectionManager;
    private final boolean useCDI;
    private static final String JERSEY_ANALYZER = "JerseyClassAnalyzer";

    public EjbComponentInterceptor(InjectionManager injectionManager, boolean useCDI) {
        this.injectionManager = injectionManager;
        this.useCDI = useCDI;
    }

    @PostConstruct
    private void inject(InvocationContext context) throws Exception {
        Object beanInstance = context.getTarget();
        if (this.useCDI) {
            this.injectionManager.inject(beanInstance, "CdiInjecteeSkippingClassAnalyzer");
        } else {
            this.injectionManager.inject(beanInstance, JERSEY_ANALYZER);
        }
        context.proceed();
    }
}

