/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.healthcheck.servlet;

import fish.payara.microprofile.healthcheck.config.MicroprofileHealthCheckConfiguration;
import fish.payara.microprofile.healthcheck.servlet.HealthCheckServlet;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.servlet.HttpConstraintElement;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;
import org.glassfish.common.util.StringHelper;
import org.glassfish.internal.api.Globals;

public class HealthCheckServletContainerInitializer
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        if (ctx.getContextPath().isEmpty()) {
            ServletRegistration reg2;
            Map registrations = ctx.getServletRegistrations();
            MicroprofileHealthCheckConfiguration configuration = (MicroprofileHealthCheckConfiguration)Globals.getDefaultHabitat().getService(MicroprofileHealthCheckConfiguration.class, new Annotation[0]);
            if (!Boolean.parseBoolean(configuration.getEnabled())) {
                return;
            }
            for (ServletRegistration reg2 : registrations.values()) {
                if (!reg2.getClass().equals(HealthCheckServlet.class) && !reg2.getMappings().contains("/" + configuration.getEndpoint())) continue;
                return;
            }
            String virtualServers = configuration.getVirtualServers();
            if (!StringHelper.isEmpty((String)virtualServers) && !Arrays.asList(virtualServers.split(",")).contains(ctx.getVirtualServerName())) {
                return;
            }
            reg2 = ctx.addServlet("microprofile-healthcheck-servlet", HealthCheckServlet.class);
            reg2.addMapping(new String[]{"/" + configuration.getEndpoint() + "/*"});
            if (Boolean.parseBoolean(configuration.getSecurityEnabled())) {
                String[] roles = configuration.getRoles().split(",");
                reg2.setServletSecurity(new ServletSecurityElement(new HttpConstraintElement(ServletSecurity.TransportGuarantee.CONFIDENTIAL, roles)));
                ctx.declareRoles(roles);
                if (Boolean.getBoolean("fish.payara.test.create-insecure-endpoint")) {
                    ServletRegistration.Dynamic insecureReg = ctx.addServlet("microprofile-healthcheck-servlet-insecure", HealthCheckServlet.class);
                    insecureReg.addMapping(new String[]{"/" + configuration.getEndpoint() + "-insecure/*"});
                }
            }
        }
    }
}

