/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.cdi.model;

import java.lang.reflect.Member;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public final class ConfigPropertyModel {
    private final InjectionPoint injectionPoint;
    private final String name;
    private final String defaultValue;

    public ConfigPropertyModel(InjectionPoint injectionPoint) {
        this(injectionPoint, null);
    }

    public ConfigPropertyModel(InjectionPoint injectionPoint, String prefix) {
        this.injectionPoint = injectionPoint;
        ConfigProperty propAnnotation = (ConfigProperty)injectionPoint.getAnnotated().getAnnotation(ConfigProperty.class);
        if (prefix == null) {
            prefix = "";
        }
        if (propAnnotation == null) {
            this.name = prefix + injectionPoint.getMember().getName();
            this.defaultValue = null;
        } else {
            this.name = prefix + ConfigPropertyModel.parseName(injectionPoint, propAnnotation.name());
            this.defaultValue = propAnnotation.defaultValue();
        }
    }

    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    private static final String parseName(InjectionPoint injectionPoint, String propName) {
        String name = "";
        if (propName == null || propName.isEmpty()) {
            Class<?> beanClass = null;
            Bean bean = injectionPoint.getBean();
            if (bean == null) {
                Member member = injectionPoint.getMember();
                beanClass = member.getDeclaringClass();
            } else {
                beanClass = bean.getBeanClass();
            }
            StringBuilder sb = new StringBuilder(beanClass.getCanonicalName());
            sb.append('.');
            sb.append(injectionPoint.getMember().getName());
            name = name + sb.toString();
        } else {
            name = name + propName;
        }
        return name;
    }
}

