/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.ee.audit.AppServerAuditManager;
import com.sun.enterprise.security.jacc.context.PolicyContextHandlerImpl;
import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.ServerAuthContext;
import com.sun.enterprise.security.jauth.jaspic.provider.ClientAuthConfig;
import com.sun.enterprise.security.jauth.jaspic.provider.ServerAuthConfig;
import com.sun.enterprise.security.web.integration.WebPrincipal;
import com.sun.enterprise.security.webservices.ClientPipeCreator;
import com.sun.enterprise.security.webservices.LogUtils;
import com.sun.enterprise.security.webservices.MessageLayerClientHandler;
import com.sun.enterprise.security.webservices.ServletSystemHandlerDelegate;
import com.sun.enterprise.security.webservices.WebServiceSecurity;
import com.sun.enterprise.web.WebModule;
import com.sun.web.security.RealmAdapter;
import com.sun.xml.rpc.spi.runtime.StreamingHandler;
import com.sun.xml.rpc.spi.runtime.SystemHandlerDelegate;
import com.sun.xml.ws.assembler.ClientPipelineHook;
import java.lang.ref.WeakReference;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPMessage;
import org.apache.catalina.util.Base64;
import org.glassfish.webservices.Ejb2RuntimeEndpointInfo;
import org.glassfish.webservices.EjbRuntimeEndpointInfo;
import org.glassfish.webservices.SecurityService;
import org.glassfish.webservices.WebServiceContextImpl;
import org.glassfish.webservices.monitoring.AuthenticationListener;
import org.glassfish.webservices.monitoring.Endpoint;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class SecurityServiceImpl
implements SecurityService {
    protected static final Logger _logger = LogUtils.getLogger();
    private static final String AUTHORIZATION_HEADER = "authorization";
    private static ThreadLocal<WeakReference<SOAPMessage>> req = new ThreadLocal();
    @Inject
    private AppServerAuditManager auditManager;

    public Object mergeSOAPMessageSecurityPolicies(MessageSecurityBindingDescriptor desc) {
        try {
            return ServerAuthConfig.getConfig("SOAP", desc, null);
        }
        catch (Exception ae) {
            _logger.log(Level.SEVERE, "AS-WSSECURITY-00007", ae);
            return null;
        }
    }

    public boolean doSecurity(HttpServletRequest hreq, EjbRuntimeEndpointInfo epInfo, String realmName, WebServiceContextImpl context) {
        boolean authenticated = false;
        try {
            String method = hreq.getMethod();
            if (context != null) {
                context.setUserPrincipal(null);
            }
            WebServiceEndpoint endpoint = epInfo.getEndpoint();
            String rawAuthInfo = hreq.getHeader(AUTHORIZATION_HEADER);
            if (method.equals("GET") || !endpoint.hasAuthMethod()) {
                authenticated = true;
                boolean bl = true;
                return bl;
            }
            WebPrincipal webPrincipal = null;
            String endpointName = endpoint.getEndpointName();
            if (endpoint.hasBasicAuth() || rawAuthInfo != null) {
                if (rawAuthInfo == null) {
                    this.sendAuthenticationEvents(false, hreq.getRequestURI(), null);
                    authenticated = false;
                    boolean bl = false;
                    return bl;
                }
                List<Object> usernamePassword = this.parseUsernameAndPassword(rawAuthInfo);
                if (usernamePassword != null) {
                    webPrincipal = new WebPrincipal((String)usernamePassword.get(0), (char[])usernamePassword.get(1), SecurityContext.init());
                } else {
                    _logger.log(Level.WARNING, "AS-WSSECURITY-00009", endpointName);
                }
            } else {
                X509Certificate[] certs = (X509Certificate[])hreq.getAttribute("javax.servlet.request.X509Certificate");
                if (certs == null || certs.length < 1) {
                    certs = (X509Certificate[])hreq.getAttribute("org.apache.coyote.request.X509Certificate");
                }
                if (certs != null) {
                    webPrincipal = new WebPrincipal(certs, SecurityContext.init());
                } else {
                    _logger.log(Level.WARNING, "AS-WSSECURITY-00010", endpointName);
                }
            }
            if (webPrincipal == null) {
                this.sendAuthenticationEvents(false, hreq.getRequestURI(), null);
                boolean certs = authenticated;
                return certs;
            }
            RealmAdapter realmAdapter = new RealmAdapter(realmName, endpoint.getBundleDescriptor().getModuleID());
            authenticated = realmAdapter.authenticate(webPrincipal);
            if (!authenticated) {
                this.sendAuthenticationEvents(false, hreq.getRequestURI(), (Principal)webPrincipal);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("authentication failed for " + endpointName);
                }
            } else {
                this.sendAuthenticationEvents(true, hreq.getRequestURI(), (Principal)webPrincipal);
            }
            if (epInfo instanceof Ejb2RuntimeEndpointInfo) {
                boolean bl = authenticated;
                return bl;
            }
            epInfo.prepareInvocation(false);
            WebServiceContextImpl ctxt = (WebServiceContextImpl)epInfo.getWebServiceContext();
            ctxt.setUserPrincipal((Principal)webPrincipal);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.auditManager != null && this.auditManager.isAuditOn()) {
                this.auditManager.ejbAsWebServiceInvocation(epInfo.getEndpoint().getEndpointName(), authenticated);
            }
        }
        return authenticated;
    }

    public SystemHandlerDelegate getSecurityHandler(WebServiceEndpoint endpoint) {
        if (!endpoint.hasAuthMethod()) {
            try {
                ServerAuthConfig config = ServerAuthConfig.getConfig("SOAP", endpoint.getMessageSecurityBinding(), null);
                if (config != null) {
                    return new ServletSystemHandlerDelegate(config, endpoint);
                }
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "AS-WSSECURITY-00008", e);
            }
        }
        return null;
    }

    public HandlerInfo getMessageSecurityHandler(MessageSecurityBindingDescriptor binding, QName serviceName) {
        HandlerInfo rvalue = null;
        try {
            ClientAuthConfig config = ClientAuthConfig.getConfig("SOAP", binding, null);
            if (config != null) {
                QName[] headers = config.getMechanisms();
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("com.sun.enterprise.security.jaspic.provider.ClientAuthConfig", config);
                properties.put("javax.xml.ws.wsdl.service", serviceName);
                rvalue = new HandlerInfo(MessageLayerClientHandler.class, properties, headers);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "AS-WSSECURITY-00011", ex);
            throw new RuntimeException(ex);
        }
        return rvalue;
    }

    public boolean validateRequest(Object serverAuthConfig, StreamingHandler implementor, com.sun.xml.rpc.spi.runtime.SOAPMessageContext context) {
        ServerAuthConfig authConfig = (ServerAuthConfig)serverAuthConfig;
        if (authConfig == null) {
            return true;
        }
        ServerAuthContext serverAuthContext = authConfig.getAuthContext(implementor, context.getMessage());
        req.set(new WeakReference<SOAPMessage>(context.getMessage()));
        if (serverAuthContext == null) {
            return true;
        }
        try {
            return WebServiceSecurity.validateRequest((SOAPMessageContext)context, serverAuthContext);
        }
        catch (AuthException ex) {
            _logger.log(Level.SEVERE, "AS-WSSECURITY-00011", ex);
            if (req.get() != null) {
                req.get().clear();
                req.set(null);
            }
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void secureResponse(Object serverAuthConfig, StreamingHandler implementor, com.sun.xml.rpc.spi.runtime.SOAPMessageContext msgContext) {
        block7: {
            if (serverAuthConfig != null) {
                ServerAuthConfig config = (ServerAuthConfig)serverAuthConfig;
                SOAPMessage reqmsg = req.get() != null ? (SOAPMessage)req.get().get() : msgContext.getMessage();
                try {
                    ServerAuthContext serverAuthContext = config.getAuthContext(implementor, reqmsg);
                    if (serverAuthContext == null) break block7;
                    try {
                        WebServiceSecurity.secureResponse((SOAPMessageContext)msgContext, serverAuthContext);
                    }
                    catch (AuthException ex) {
                        _logger.log(Level.SEVERE, "AS-WSSECURITY-00011", ex);
                        throw new RuntimeException(ex);
                    }
                }
                finally {
                    if (req.get() != null) {
                        req.get().clear();
                        req.set(null);
                    }
                }
            }
        }
    }

    public Principal getUserPrincipal(boolean isWeb) {
        SecurityContext securityContext = SecurityContext.getCurrent();
        if (securityContext == null) {
            return null;
        }
        if (securityContext.didServerGenerateCredentials() && isWeb) {
            return null;
        }
        return securityContext.getCallerPrincipal();
    }

    public boolean isUserInRole(WebModule webModule, Principal principal, String servletName, String role) {
        if (webModule.getRealm() instanceof RealmAdapter) {
            RealmAdapter realmAdapter = (RealmAdapter)webModule.getRealm();
            return realmAdapter.hasRole(servletName, principal, role);
        }
        return false;
    }

    public void resetSecurityContext() {
        SecurityContext.setUnauthenticatedContext();
    }

    public void resetPolicyContext() {
        ((PolicyContextHandlerImpl)PolicyContextHandlerImpl.getInstance()).reset();
        PolicyContext.setContextID(null);
    }

    public ClientPipelineHook getClientPipelineHook(ServiceReferenceDescriptor ref) {
        return new ClientPipeCreator(ref);
    }

    private List<Object> parseUsernameAndPassword(String rawAuthInfo) {
        String authString;
        String unencoded;
        int colon;
        ArrayList<Object> usernamePassword = null;
        if (rawAuthInfo != null && rawAuthInfo.startsWith("Basic ") && (colon = (unencoded = new String(Base64.decode((byte[])(authString = rawAuthInfo.substring(6).trim()).getBytes()))).indexOf(58)) > 0) {
            usernamePassword = new ArrayList<Object>();
            usernamePassword.add(unencoded.substring(0, colon).trim());
            usernamePassword.add(unencoded.substring(colon + 1).trim().toCharArray());
        }
        return usernamePassword;
    }

    private void sendAuthenticationEvents(boolean success, String url, Principal principal) {
        Endpoint endpoint = WebServiceEngineImpl.getInstance().getEndpoint(url);
        if (endpoint == null) {
            return;
        }
        for (AuthenticationListener listener : WebServiceEngineImpl.getInstance().getAuthListeners()) {
            if (success) {
                listener.authSucess(endpoint.getDescriptor().getBundleDescriptor(), endpoint, principal);
                continue;
            }
            listener.authFailure(endpoint.getDescriptor().getBundleDescriptor(), endpoint, principal);
        }
    }
}

