/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.microprofile.metrics.admin.MetricsServiceConfiguration;
import java.util.HashMap;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-metrics-configuration")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.DEPLOYMENT_GROUP, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=MetricsServiceConfiguration.class, opType=RestEndpoint.OpType.GET, path="get-metrics-configuration", description="Gets the Metrics Configuration")})
public class GetMetricsConfigurationCommand
implements AdminCommand {
    private final String[] OUTPUT_HEADERS = new String[]{"Enabled", "Dynamic", "EndPoint", "VirtualServers", "Security Enabled", "Roles"};
    @Inject
    private Target targetUtil;
    @Param(optional=true, defaultValue="server-config")
    private String target;

    public void execute(AdminCommandContext adminCommandContext) {
        Config targetConfig = this.targetUtil.getConfig(this.target);
        if (targetConfig == null) {
            adminCommandContext.getActionReport().setMessage("No such config name: " + this.targetUtil);
            adminCommandContext.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        MetricsServiceConfiguration metricsConfiguration = (MetricsServiceConfiguration)targetConfig.getExtensionByType(MetricsServiceConfiguration.class);
        ColumnFormatter columnFormatter = new ColumnFormatter(this.OUTPUT_HEADERS);
        Object[] outputValues = new Object[]{metricsConfiguration.getEnabled(), metricsConfiguration.getDynamic(), metricsConfiguration.getEndpoint(), metricsConfiguration.getVirtualServers(), metricsConfiguration.getSecurityEnabled(), metricsConfiguration.getRoles()};
        columnFormatter.addRow(outputValues);
        adminCommandContext.getActionReport().appendMessage(columnFormatter.toString());
        HashMap<String, String> extraPropertiesMap = new HashMap<String, String>();
        extraPropertiesMap.put("enabled", metricsConfiguration.getEnabled());
        extraPropertiesMap.put("dynamic", metricsConfiguration.getDynamic());
        extraPropertiesMap.put("endpoint", metricsConfiguration.getEndpoint());
        extraPropertiesMap.put("virtualServers", metricsConfiguration.getVirtualServers());
        extraPropertiesMap.put("securityenabled", metricsConfiguration.getSecurityEnabled());
        extraPropertiesMap.put("roles", metricsConfiguration.getRoles());
        Properties extraProperties = new Properties();
        extraProperties.put("metricsConfiguration", extraPropertiesMap);
        adminCommandContext.getActionReport().setExtraProperties(extraProperties);
    }
}

