/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.cdi.extension;

import fish.payara.microprofile.metrics.cdi.AnnotationReader;
import fish.payara.microprofile.metrics.cdi.MetricsAnnotationBinding;
import fish.payara.microprofile.metrics.cdi.interceptor.ConcurrentGaugeInterceptor;
import fish.payara.microprofile.metrics.cdi.interceptor.CountedInterceptor;
import fish.payara.microprofile.metrics.cdi.interceptor.MeteredInterceptor;
import fish.payara.microprofile.metrics.cdi.interceptor.MetricsInterceptor;
import fish.payara.microprofile.metrics.cdi.interceptor.SimplyTimedInterceptor;
import fish.payara.microprofile.metrics.cdi.interceptor.TimedInterceptor;
import fish.payara.microprofile.metrics.cdi.producer.MetricProducer;
import fish.payara.microprofile.metrics.cdi.producer.MetricRegistryProducer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.Nonbinding;
import javax.interceptor.Interceptor;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.SimplyTimed;
import org.eclipse.microprofile.metrics.annotation.Timed;

public class MetricCDIExtension<E extends Member & AnnotatedElement>
implements Extension {
    private static final AnnotationLiteral<Nonbinding> NON_BINDING = new AnnotationLiteral<Nonbinding>(){};
    private static final AnnotationLiteral<MetricsAnnotationBinding> METRICS_ANNOTATION_BINDING = new AnnotationLiteral<MetricsAnnotationBinding>(){};
    private final Map<String, E> annotatedElements = new HashMap<String, E>();
    private final Map<String, Metadata> metadataMap = new HashMap<String, Metadata>();
    private final List<String> validationMessages = new ArrayList<String>();

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager manager) {
        MetricCDIExtension.addNonbindingAnnotation(Counted.class, beforeBeanDiscovery);
        MetricCDIExtension.addNonbindingAnnotation(ConcurrentGauge.class, beforeBeanDiscovery);
        MetricCDIExtension.addNonbindingAnnotation(Metered.class, beforeBeanDiscovery);
        MetricCDIExtension.addNonbindingAnnotation(Timed.class, beforeBeanDiscovery);
        MetricCDIExtension.addNonbindingAnnotation(SimplyTimed.class, beforeBeanDiscovery);
        MetricCDIExtension.addNonbindingAnnotation(Gauge.class, beforeBeanDiscovery);
        MetricCDIExtension.addAnnotatedType(CountedInterceptor.class, manager, beforeBeanDiscovery);
        MetricCDIExtension.addAnnotatedType(ConcurrentGaugeInterceptor.class, manager, beforeBeanDiscovery);
        MetricCDIExtension.addAnnotatedType(MeteredInterceptor.class, manager, beforeBeanDiscovery);
        MetricCDIExtension.addAnnotatedType(TimedInterceptor.class, manager, beforeBeanDiscovery);
        MetricCDIExtension.addAnnotatedType(MetricsInterceptor.class, manager, beforeBeanDiscovery);
        MetricCDIExtension.addAnnotatedType(SimplyTimedInterceptor.class, manager, beforeBeanDiscovery);
        MetricCDIExtension.addAnnotatedType(MetricProducer.class, manager, beforeBeanDiscovery);
        MetricCDIExtension.addAnnotatedType(MetricRegistryProducer.class, manager, beforeBeanDiscovery);
    }

    <T> void metricsAnnotations(@Observes @WithAnnotations(value={Counted.class, ConcurrentGauge.class, Gauge.class, Metered.class, Timed.class, SimplyTimed.class}) ProcessAnnotatedType<T> processAnnotatedType) {
        processAnnotatedType.configureAnnotatedType().add(METRICS_ANNOTATION_BINDING);
    }

    <T> void validateMetrics(@Observes @WithAnnotations(value={Counted.class, ConcurrentGauge.class, Gauge.class, Metered.class, Timed.class, SimplyTimed.class}) ProcessAnnotatedType<T> processAnnotatedType) {
        AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        ArrayList annotatedCallables = new ArrayList(annotatedType.getConstructors());
        annotatedCallables.addAll(annotatedType.getMethods());
        Class bean = annotatedType.getJavaClass();
        for (AnnotatedCallable annotatedElement : annotatedCallables) {
            if (bean.isAnnotationPresent(Interceptor.class)) continue;
            Member element = annotatedElement.getJavaMember();
            this.validateAnnotated(element, bean);
        }
    }

    private void validateAnnotated(E element, Class<?> bean) {
        for (AnnotationReader<?> reader : AnnotationReader.readers()) {
            if (reader.type() == MetricType.INVALID) continue;
            this.validateAnnotated(element, bean, reader);
        }
    }

    private <T extends Annotation> void validateAnnotated(E element, Class<?> bean, AnnotationReader<T> reader) {
        if (!reader.isPresent(bean, element)) {
            return;
        }
        Metadata metadata = reader.metadata(bean, element);
        String name = metadata.getName();
        Member existingElement = (Member)this.annotatedElements.putIfAbsent(name, element);
        Metadata existingMetadata = this.metadataMap.putIfAbsent(name, metadata);
        if (null != existingElement && null != existingMetadata && metadata.getTypeRaw() != existingMetadata.getTypeRaw()) {
            String errorMessage = element instanceof Constructor ? String.format("Duplicate metric name[%s] found on elements [%s#%s] and [%s#%s]", name, existingElement, existingMetadata.getType(), element, metadata.getType()) : String.format("Duplicate metric name[%s] found on elements [%s.%s#%s] and [%s.%s#%s]", name, existingElement.getDeclaringClass().getName(), existingElement.getName(), existingMetadata.getType(), element.getDeclaringClass().getName(), element.getName(), metadata.getType());
            this.validationMessages.add(errorMessage);
        }
    }

    void validationError(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        this.validationMessages.forEach(message -> afterBeanDiscovery.addDefinitionError((Throwable)new IllegalStateException((String)message)));
        this.annotatedElements.clear();
        this.metadataMap.clear();
        this.validationMessages.clear();
    }

    private static <T extends Annotation> void addNonbindingAnnotation(Class<T> annotation, BeforeBeanDiscovery beforeBeanDiscovery) {
        beforeBeanDiscovery.configureInterceptorBinding(annotation).filterMethods(method -> !method.isAnnotationPresent(Nonbinding.class)).forEach(method -> method.add(NON_BINDING));
    }

    private static <T> void addAnnotatedType(Class<T> type, BeanManager manager, BeforeBeanDiscovery beforeBeanDiscovery) {
        beforeBeanDiscovery.addAnnotatedType(manager.createAnnotatedType(type), type.getName());
    }
}

