/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.jmx;

import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;

public class MBeanExpression {
    private String mBean;
    private String attributeName;
    private String subAttributeName;
    private ObjectName objectName;
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private static final Logger LOGGER = Logger.getLogger(MBeanExpression.class.getName());

    public MBeanExpression(String expression) {
        if (expression == null || expression.trim().isEmpty()) {
            throw new IllegalArgumentException("MBean Expression is null");
        }
        int slashIndex = expression.lastIndexOf("/");
        if (slashIndex < 0) {
            throw new IllegalArgumentException("MBean Expression is invalid : " + expression);
        }
        this.mBean = expression.substring(0, slashIndex);
        this.attributeName = expression.substring(slashIndex + 1);
        if (this.attributeName.contains("#")) {
            int hashIndex = this.attributeName.indexOf("#");
            this.subAttributeName = this.attributeName.substring(hashIndex + 1);
            this.attributeName = this.attributeName.substring(0, hashIndex);
        }
        try {
            this.objectName = new ObjectName(this.mBean);
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalArgumentException("MBean Expression is invalid : " + expression);
        }
    }

    public String getMBean() {
        return this.mBean;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getSubAttributeName() {
        return this.subAttributeName;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public Object getAttribute() throws Exception {
        return this.mBeanServer.getAttribute(this.objectName, this.getAttributeName());
    }

    public String findDynamicKey() {
        for (Map.Entry<String, String> entry : this.objectName.getKeyPropertyList().entrySet()) {
            if (!entry.getValue().contains("*")) continue;
            return entry.getKey();
        }
        return null;
    }

    public Number getNumberValue() {
        try {
            Object attribute = this.getAttribute();
            if (attribute instanceof Number) {
                return (Number)attribute;
            }
            if (attribute instanceof CompositeData) {
                CompositeData compositeData = (CompositeData)attribute;
                return (Number)compositeData.get(this.getSubAttributeName());
            }
            throw new IllegalArgumentException(this.getMBean());
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage());
            throw new IllegalStateException(ex);
        }
    }

    public Set<ObjectName> queryNames(QueryExp query) {
        return this.mBeanServer.queryNames(this.objectName, query);
    }

    public List<MBeanAttributeInfo> queryAttributes(ObjectName objectName) {
        try {
            return Arrays.asList(this.mBeanServer.getMBeanInfo(objectName).getAttributes());
        }
        catch (InstanceNotFoundException | IntrospectionException | ReflectionException ex) {
            LOGGER.log(Level.WARNING, String.format("Error in queryAttributes operation where objectName [%s]", objectName), ex);
            return Collections.emptyList();
        }
    }

    public Object querySubAttributes(ObjectName objectName, String attribute) {
        Object subAttributes = null;
        try {
            subAttributes = this.mBeanServer.getAttribute(objectName, attribute);
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException ex) {
            LOGGER.log(Level.WARNING, String.format("Error in querySubAttributes operation where objectName [%s] and attribute [%s]", objectName, attribute), ex);
        }
        return subAttributes;
    }
}

