/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.acl;

import com.sun.enterprise.security.acl.RoleMapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import org.glassfish.deployment.common.SecurityRoleMapper;
import org.glassfish.deployment.common.SecurityRoleMapperFactory;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class RoleMapperFactory
implements SecurityRoleMapperFactory {
    private Map<String, String> CONTEXT_TO_APPNAME = new ConcurrentHashMap<String, String>();
    private Map<String, SecurityRoleMapper> ROLEMAPPER = new ConcurrentHashMap<String, SecurityRoleMapper>();

    public SecurityRoleMapper getRoleMapper(String appName) {
        String contextId = appName;
        String appname = this.getAppNameForContext(appName);
        RoleMapper securityRoleMapper = null;
        if (appname != null) {
            securityRoleMapper = this.getRoleMapper(appname, this);
        }
        if (securityRoleMapper == null) {
            securityRoleMapper = this.getRoleMapper(contextId, this);
        }
        return securityRoleMapper;
    }

    public String getAppNameForContext(String contextId) {
        return this.CONTEXT_TO_APPNAME.get(contextId);
    }

    public void setAppNameForContext(String appName, String contextId) {
        this.CONTEXT_TO_APPNAME.put(contextId, appName);
    }

    public void removeAppNameForContext(String contextId) {
        this.CONTEXT_TO_APPNAME.remove(contextId);
    }

    public RoleMapper getRoleMapper(String appName, SecurityRoleMapperFactory fact) {
        return (RoleMapper)this.ROLEMAPPER.computeIfAbsent(appName, e -> new RoleMapper(appName));
    }

    public void setRoleMapper(String appName, SecurityRoleMapper securityRoleMapper) {
        this.ROLEMAPPER.put(appName, securityRoleMapper);
    }

    public void removeRoleMapper(String appName) {
        if (this.ROLEMAPPER.containsKey(appName)) {
            this.ROLEMAPPER.remove(appName);
        }
    }
}

