/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.cluster.SyncRequest;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.admin.cluster.ServerSynchronizer;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS})
@Service(name="export-sync-bundle")
@PerLookup
@I18n(value="export-sync-bundle")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="export-sync-bundle", description="export-sync-bundle")})
public class ExportSyncBundle
implements AdminCommand {
    private static final String[] ALL_DIRS = new String[]{"config", "applications", "lib", "docroot", "config-specific"};
    private static final String SYNC_FAIL = "export.sync.bundle.fail";
    @Param(name="target", optional=false)
    private String clusterInstance;
    @Param(name="retrieve", optional=true, defaultValue="false")
    private boolean isRetrieve;
    @Param(optional=true, primary=true)
    String file_name;
    @Inject
    @Optional
    private Servers servers;
    @Inject
    @Optional
    private Clusters clusters;
    @Inject
    private ServerSynchronizer serverSynchronizer;
    @Inject
    private ServerEnvironment env;
    private SyncRequest syncRequest = new SyncRequest();
    private ActionReport report;
    private File syncBundleExport;
    private Logger logger;
    private Payload.Outbound payload;
    private Server instance;
    private Cluster cluster;

    public void execute(AdminCommandContext context) {
        this.report = context.getActionReport();
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        this.logger = context.getLogger();
        this.payload = PayloadImpl.Outbound.newInstance();
        try {
            if (!this.isValid()) {
                return;
            }
            if (!this.setSyncBundleExportFile()) {
                return;
            }
            this.syncRequest = new SyncRequest();
            this.syncRequest.instance = this.clusterInstance;
            if (!this.sync()) {
                return;
            }
            this.write();
            if (this.isRetrieve) {
                this.pumpItOut(context);
            }
        }
        catch (Exception e) {
            this.setError(Strings.get(SYNC_FAIL, e.toString()));
            this.logger.log(Level.SEVERE, Strings.get(SYNC_FAIL, e.toString()), e);
        }
    }

    private void pumpItOut(AdminCommandContext context) {
        block3: {
            String fileName = this.file_name != null && !this.file_name.isEmpty() ? this.file_name : this.getDefaultBundleName();
            File localFile = new File(fileName.replace('\\', '/'));
            File parent = localFile.getParentFile();
            if (parent == null) {
                parent = localFile;
            }
            Properties props = new Properties();
            props.setProperty("file-xfer-root", parent.getPath().replace('\\', '/'));
            URI parentURI = parent.toURI();
            try {
                context.getOutboundPayload().attachFile("application/octet-stream", parentURI.relativize(localFile.toURI()), "sync-bundle", props, this.syncBundleExport);
            }
            catch (IOException ex) {
                this.setError(Strings.get("export.sync.bundle.retrieveFailed", ex.getLocalizedMessage()));
                if (!this.logger.isLoggable(Level.FINER)) break block3;
                this.logger.log(Level.FINER, "fileURI: {0}", parentURI.relativize(localFile.toURI()));
                this.logger.log(Level.FINER, "file-xfer-root: {0}", parent.getPath().replace('\\', '/'));
                this.logger.log(Level.FINER, "file: {0}", this.syncBundleExport.getAbsolutePath());
            }
        }
    }

    private boolean sync() {
        String[] stringArray = ALL_DIRS;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String dir;
            this.syncRequest.dir = dir = stringArray[i];
            if (this.syncOne()) continue;
            return false;
        }
        return !this.hasError();
    }

    /*
     * Unable to fully structure code
     */
    private void write() {
        out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(this.syncBundleExport));
            this.payload.writeTo(out);
            ** if (out == null) goto lbl-1000
        }
        catch (IOException ex) {
            try {
                this.setError(Strings.get("export.sync.bundle.exportFailed", new Object[]{this.syncBundleExport.getAbsolutePath(), ex.getLocalizedMessage()}));
                ** if (out == null) goto lbl-1000
            }
            catch (Throwable var3_5) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ex) {
                        this.logger.warning(Strings.get("export.sync.bundle.closeStreamFailed", new Object[]{this.syncBundleExport.getAbsolutePath(), ex.getLocalizedMessage()}));
                    }
                }
                throw var3_5;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    this.logger.warning(Strings.get("export.sync.bundle.closeStreamFailed", new Object[]{this.syncBundleExport.getAbsolutePath(), ex.getLocalizedMessage()}));
                }
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                out.close();
            }
            catch (IOException ex) {
                this.logger.warning(Strings.get("export.sync.bundle.closeStreamFailed", new Object[]{this.syncBundleExport.getAbsolutePath(), ex.getLocalizedMessage()}));
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        if (!this.isRetrieve) {
            if (this.syncBundleExport.isFile()) {
                this.report.setMessage(Strings.get("export.sync.bundle.success", new Object[]{this.syncBundleExport.getAbsolutePath()}));
            } else {
                this.setError(Strings.get("export.sync.bundle.fail", new Object[]{this.syncBundleExport.getAbsolutePath()}));
            }
        }
    }

    private boolean syncOne() {
        List clusterInstances;
        if (this.instance != null) {
            this.serverSynchronizer.synchronize(this.instance, this.syncRequest, this.payload, this.report, this.logger);
        }
        if (this.cluster != null && (clusterInstances = this.cluster.getInstances()) != null && !clusterInstances.isEmpty()) {
            this.serverSynchronizer.synchronize((Server)clusterInstances.get(0), this.syncRequest, this.payload, this.report, this.logger);
        }
        return !this.hasError();
    }

    private File getDefaultBundle() {
        return new File(new File(this.env.getInstanceRoot(), "sync"), this.getDefaultBundleName());
    }

    private String getDefaultBundleName() {
        return this.clusterInstance + "-sync-bundle.zip";
    }

    private boolean isValid() {
        if (this.servers != null) {
            this.instance = this.servers.getServer(this.clusterInstance);
        }
        if (this.clusters != null) {
            List clusterInstances;
            this.cluster = this.clusters.getCluster(this.clusterInstance);
            if (this.cluster != null && ((clusterInstances = this.cluster.getInstances()) == null || clusterInstances.isEmpty())) {
                this.setError(Strings.get("sync.empty_cluster", this.clusterInstance));
                return false;
            }
        }
        if (this.instance == null && this.cluster == null) {
            this.setError(Strings.get("sync.unknown.instanceOrCluster", this.clusterInstance));
            return false;
        }
        return true;
    }

    private boolean setSyncBundleExportFile() {
        if (this.isRetrieve) {
            try {
                this.syncBundleExport = File.createTempFile("GlassFishSyncBundle", ".zip");
                FileUtils.deleteOnExit((File)this.syncBundleExport);
            }
            catch (Exception ex) {
                this.syncBundleExport = null;
                this.setError(Strings.get("sync.bad_temp_file", ex.getLocalizedMessage()));
                return false;
            }
        } else {
            File file = null;
            if (this.file_name != null && !this.file_name.isEmpty()) {
                file = new File(this.file_name);
                if (file.isDirectory()) {
                    file = new File(file, this.getDefaultBundleName());
                }
            } else {
                file = this.getDefaultBundle();
            }
            if (file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                this.setError(Strings.get("export.sync.bundle.createDirFailed", file.getParentFile().getPath()));
                return false;
            }
            this.syncBundleExport = SmartFile.sanitize((File)file);
        }
        return true;
    }

    private void setError(String msg) {
        this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        this.report.setMessage(msg);
    }

    private boolean hasError() {
        return this.report.getActionExitCode() != ActionReport.ExitCode.SUCCESS;
    }
}

