/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.cluster;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.v3.admin.cluster.ClusterCommandHelper;
import com.sun.enterprise.v3.admin.cluster.Strings;
import fish.payara.enterprise.config.serverbeans.DeploymentGroup;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Progress;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@I18n(value="stop.dg.command")
@Service(name="stop-deployment-group")
@PerLookup
@RestEndpoints(value={@RestEndpoint(configBean=DeploymentGroup.class, opType=RestEndpoint.OpType.POST, path="stop-deployment-group", description="Stop Deployment Group", params={@RestParam(name="id", value="$parent")})})
@Progress
public class StopDeploymentGroupCommand
implements AdminCommand {
    @Param(optional=false, primary=true)
    private String deploymentGroup;
    @Param(optional=true, defaultValue="false")
    private boolean kill = false;
    @Inject
    private ServerEnvironment env;
    @Inject
    private Domain domain;
    @Inject
    private CommandRunner runner;
    @Param(optional=true, defaultValue="false")
    private boolean verbose;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        logger.info(Strings.get("stop.dg", this.deploymentGroup));
        if (!this.env.isDas()) {
            String msg = Strings.get("cluster.command.notDas");
            logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        ClusterCommandHelper clusterHelper = new ClusterCommandHelper(this.domain, this.runner);
        ParameterMap map = null;
        if (this.kill) {
            map = new ParameterMap();
            map.add((Object)"kill", (Object)"true");
        }
        try {
            String commandName = "stop-instance";
            clusterHelper.runCommand(commandName, map, this.deploymentGroup, context, this.verbose);
        }
        catch (CommandException e) {
            String msg = e.getLocalizedMessage();
            logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
        }
    }
}

