/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security.realmadapter;

import java.io.IOException;
import java.security.Principal;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.deploy.LoginConfig;

public class AuthenticatorProxy
extends AuthenticatorBase {
    public static final String PROXY_AUTH_TYPE = "PLUGGABLE_PROVIDER";
    private AuthenticatorBase authBase;
    private Principal principal;
    private String authType;

    public AuthenticatorProxy(Authenticator authenticator, Principal principal, String authType) throws LifecycleException {
        this.authBase = (AuthenticatorBase)authenticator;
        this.principal = principal;
        this.authType = authType == null ? PROXY_AUTH_TYPE : authType;
        this.setCache(this.authBase.getCache());
        this.setContainer(this.authBase.getContainer());
        this.start();
    }

    public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
        if (this.cache) {
            this.getSession(request, true);
        }
        this.register(request, response, this.principal, this.authType, this.principal.getName(), null);
        return true;
    }

    public String getAuthMethod() {
        return this.authType;
    }

    public boolean getCache() {
        return this.authBase.getCache();
    }

    public Container getContainer() {
        return this.authBase.getContainer();
    }
}

