/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms;

import com.sun.messaging.bridge.api.BridgeContext;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.Refable;
import com.sun.messaging.jms.MQRuntimeException;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAJMSContext;

public class XAConnectionFactoryImpl
implements XAConnectionFactory,
Refable {
    private XAConnectionFactory _cf = null;
    private String _ref = null;
    private boolean _isEmbeded = false;
    private boolean _isMultiRM = false;
    private boolean _firstTime = true;
    private BridgeContext _bc = null;
    private Properties _jmsprop = null;

    public XAConnectionFactoryImpl(XAConnectionFactory cf, String ref, boolean isMultiRM) {
        this._cf = cf;
        this._ref = ref;
        this._isMultiRM = isMultiRM;
    }

    public XAConnectionFactoryImpl(BridgeContext bc, Properties jmsprop, boolean isEmbeded, String ref, boolean isMultiRM) throws Exception {
        this._bc = bc;
        this._jmsprop = jmsprop;
        this._cf = bc.getXAConnectionFactory(jmsprop);
        this._ref = ref;
        this._isEmbeded = isEmbeded;
        this._isMultiRM = isMultiRM;
    }

    @Override
    public XAConnection createXAConnection() throws JMSException {
        if (this._bc != null) {
            XAConnectionFactory cf = null;
            try {
                cf = this._bc.getXAConnectionFactory(this._jmsprop);
            }
            catch (Exception e) {
                String string = e.getMessage();
                JMSBridge.getJMSBridgeResources();
                JMSException jmse = new JMSException(string, "BSJ3009");
                jmse.setLinkedException(e);
                throw jmse;
            }
            return cf.createXAConnection();
        }
        return this._cf.createXAConnection();
    }

    @Override
    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        if (this._bc != null) {
            XAConnectionFactory cf = null;
            try {
                cf = this._bc.getXAConnectionFactory(this._jmsprop);
            }
            catch (Exception e) {
                String string = e.getMessage();
                JMSBridge.getJMSBridgeResources();
                JMSException jmse = new JMSException(string, "BSJ3009");
                jmse.setLinkedException(e);
                throw jmse;
            }
            return cf.createXAConnection(userName, password);
        }
        return this._cf.createXAConnection(userName, password);
    }

    @Override
    public XAJMSContext createXAContext() {
        if (this._bc != null) {
            XAConnectionFactory cf = null;
            try {
                cf = this._bc.getXAConnectionFactory(this._jmsprop);
            }
            catch (Exception e) {
                String string = e.getMessage();
                JMSBridge.getJMSBridgeResources();
                MQRuntimeException jmse = new MQRuntimeException(string, "BSJ3009", e);
                throw jmse;
            }
            return cf.createXAContext();
        }
        return this._cf.createXAContext();
    }

    @Override
    public XAJMSContext createXAContext(String userName, String password) {
        if (this._bc != null) {
            XAConnectionFactory cf = null;
            try {
                cf = this._bc.getXAConnectionFactory(this._jmsprop);
            }
            catch (Exception e) {
                String string = e.getMessage();
                JMSBridge.getJMSBridgeResources();
                MQRuntimeException jmse = new MQRuntimeException(string, "BSJ3009", e);
                throw jmse;
            }
            return cf.createXAContext(userName, password);
        }
        return this._cf.createXAContext(userName, password);
    }

    @Override
    public String getRef() {
        return this._ref;
    }

    @Override
    public Object getRefed() {
        return this._cf;
    }

    @Override
    public boolean isEmbeded() {
        return this._isEmbeded;
    }

    @Override
    public boolean isMultiRM() {
        return this._isMultiRM;
    }

    public String toString() {
        String refs = this._ref + (this._isEmbeded ? ", embeded" : "") + (this._isMultiRM ? ", multirm" : "");
        String s = null;
        if (this._firstTime) {
            s = "[" + refs + "]" + this._cf.toString();
            this._firstTime = false;
        } else {
            s = "[" + refs + "]" + this._cf.getClass().getName();
        }
        return s;
    }
}

