/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.headers;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.examples.ExampleImpl;
import fish.payara.microprofile.openapi.impl.model.media.ContentImpl;
import fish.payara.microprofile.openapi.impl.model.media.SchemaImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.EnumModel;

public class HeaderImpl
extends ExtensibleImpl<Header>
implements Header {
    private String ref;
    private String description;
    private Boolean required;
    private Boolean deprecated;
    private Boolean allowEmptyValue;
    private Header.Style style;
    private Boolean explode;
    private Schema schema;
    private Map<String, Example> examples = ModelUtils.createMap();
    private Object example;
    private Content content = new ContentImpl();

    public static Map<String, Header> createInstances(AnnotationModel annotation, ApiContext context) {
        Map<String, Header> map = ModelUtils.createMap();
        List headers = (List)annotation.getValue("headers", List.class);
        if (headers != null) {
            for (AnnotationModel header : headers) {
                String headerName = (String)header.getValue("name", String.class);
                if (headerName == null) {
                    headerName = (String)header.getValue("ref", String.class);
                }
                map.put(headerName, HeaderImpl.createInstance(header, context));
            }
        }
        return map;
    }

    public static Header createInstance(AnnotationModel annotation, ApiContext context) {
        Boolean hidden;
        HeaderImpl from = new HeaderImpl();
        String ref = (String)annotation.getValue("ref", String.class);
        if (ref != null && !ref.isEmpty()) {
            from.setRef(ref);
        }
        from.setDescription((String)annotation.getValue("description", String.class));
        from.setRequired((Boolean)annotation.getValue("required", Boolean.class));
        from.setDeprecated((Boolean)annotation.getValue("deprecated", Boolean.class));
        from.setAllowEmptyValue((Boolean)annotation.getValue("allowEmptyValue", Boolean.class));
        EnumModel styleEnum = (EnumModel)annotation.getValue("style", EnumModel.class);
        if (styleEnum != null) {
            from.setStyle(Header.Style.valueOf((String)styleEnum.getValue()));
        }
        from.setExplode((Boolean)annotation.getValue("explode", Boolean.class));
        AnnotationModel schemaAnnotation = (AnnotationModel)annotation.getValue("schema", AnnotationModel.class);
        if (!(schemaAnnotation == null || (hidden = (Boolean)schemaAnnotation.getValue("hidden", Boolean.class)) != null && hidden.booleanValue())) {
            from.setSchema(SchemaImpl.createInstance(schemaAnnotation, context));
        }
        ModelUtils.extractAnnotations(annotation, context, "examples", "name", ExampleImpl::createInstance, from::addExample);
        from.setExample(annotation.getValue("example", Object.class));
        List<ContentImpl> contents = ModelUtils.createList();
        ModelUtils.extractAnnotations(annotation, context, "content", ContentImpl::createInstance, contents::add);
        for (ContentImpl content : contents) {
            content.getMediaTypes().forEach((arg_0, arg_1) -> ((Content)from.content).addMediaType(arg_0, arg_1));
        }
        return from;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        if (ref != null && !ref.contains(".") && !ref.contains("/")) {
            ref = "#/components/headers/" + ref;
        }
        this.ref = ref;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public void setAllowEmptyValue(Boolean allowEmptyValue) {
        this.allowEmptyValue = allowEmptyValue;
    }

    public Header.Style getStyle() {
        return this.style;
    }

    public void setStyle(Header.Style style) {
        this.style = style;
    }

    public Boolean getExplode() {
        return this.explode;
    }

    public void setExplode(Boolean explode) {
        this.explode = explode;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Map<String, Example> getExamples() {
        return ModelUtils.readOnlyView(this.examples);
    }

    public void setExamples(Map<String, Example> examples) {
        this.examples = ModelUtils.createMap(examples);
    }

    public Header addExample(String key, Example examplesItem) {
        if (examplesItem != null) {
            if (this.examples == null) {
                this.examples = ModelUtils.createMap();
            }
            this.examples.put(key, examplesItem);
        }
        return this;
    }

    public void removeExample(String key) {
        if (this.examples != null) {
            this.examples.remove(key);
        }
    }

    public Object getExample() {
        return this.example;
    }

    public void setExample(Object example) {
        this.example = example;
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public static void merge(Header from, Header to, boolean override, ApiContext context) {
        if (from == null) {
            return;
        }
        if (from.getRef() != null && !from.getRef().isEmpty()) {
            ModelUtils.applyReference(to, from.getRef());
            return;
        }
        to.setDescription(ModelUtils.mergeProperty(to.getDescription(), from.getDescription(), override));
        to.setRequired(ModelUtils.mergeProperty(to.getRequired(), from.getRequired(), override));
        to.setDeprecated(ModelUtils.mergeProperty(to.getDeprecated(), from.getDeprecated(), override));
        to.setAllowEmptyValue(ModelUtils.mergeProperty(to.getAllowEmptyValue(), from.getAllowEmptyValue(), override));
        to.setStyle(Header.Style.SIMPLE);
        to.setExplode(ModelUtils.mergeProperty(to.getExplode(), from.getExplode(), override));
        if (from.getSchema() != null) {
            if (to.getSchema() == null) {
                to.setSchema((Schema)new SchemaImpl());
            }
            SchemaImpl.merge(from.getSchema(), to.getSchema(), override, context);
        }
        to.setExample(ModelUtils.mergeProperty(to.getExample(), from.getExample(), override));
        if (from.getExamples() != null) {
            for (String exampleName : from.getExamples().keySet()) {
                if (exampleName == null) continue;
                ExampleImpl example = new ExampleImpl();
                ExampleImpl.merge((Example)from.getExamples().get(exampleName), example, override);
                to.addExample(exampleName, (Example)example);
            }
        }
        if (from.getContent() != null) {
            if (to.getContent() == null) {
                to.setContent((Content)new ContentImpl());
            }
            ContentImpl.merge((ContentImpl)from.getContent(), to.getContent(), override, context);
        }
    }

    public static void merge(String headerName, Header header, Map<String, Header> headers, boolean override, ApiContext context) {
        if (header == null) {
            return;
        }
        if (headerName == null || headerName.isEmpty()) {
            headerName = "?";
        }
        Header model = headers.getOrDefault(headerName, new HeaderImpl());
        headers.put(headerName, model);
        HeaderImpl.merge(header, model, override, context);
        if (model.getRef() != null) {
            headers.remove(headerName);
            headers.put(model.getRef().split("/")[3], model);
        }
    }
}

