/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.config.ConfigAwareElement;
import org.glassfish.grizzly.config.DefaultProxy;
import org.glassfish.grizzly.config.GrizzlyConfig;
import org.glassfish.grizzly.config.GrizzlyConfigException;
import org.glassfish.grizzly.config.GrizzlyListener;
import org.glassfish.grizzly.config.HSTSFilter;
import org.glassfish.grizzly.config.SSLConfigurator;
import org.glassfish.grizzly.config.Utils;
import org.glassfish.grizzly.config.dom.FileCache;
import org.glassfish.grizzly.config.dom.Http;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.PortUnification;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.ProtocolChain;
import org.glassfish.grizzly.config.dom.ProtocolChainInstanceHandler;
import org.glassfish.grizzly.config.dom.ProtocolFilter;
import org.glassfish.grizzly.config.dom.ProtocolFinder;
import org.glassfish.grizzly.config.dom.SelectionKeyHandler;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.grizzly.config.dom.Transport;
import org.glassfish.grizzly.config.dom.Transports;
import org.glassfish.grizzly.config.portunif.HttpRedirectFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.CompressionConfig;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.GZipContentEncoding;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.KeepAlive;
import org.glassfish.grizzly.http.LZMAContentEncoding;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.BackendConfiguration;
import org.glassfish.grizzly.http.server.CompressionEncodingFilter;
import org.glassfish.grizzly.http.server.FileCacheFilter;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.ServerFilterConfiguration;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.grizzly.http2.Http2AddOn;
import org.glassfish.grizzly.http2.Http2Configuration;
import org.glassfish.grizzly.memory.ByteBufferManager;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RoundRobinConnectionDistributor;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.nio.transport.UDPNIOTransportBuilder;
import org.glassfish.grizzly.portunif.PUFilter;
import org.glassfish.grizzly.portunif.PUProtocol;
import org.glassfish.grizzly.portunif.finders.SSLProtocolFinder;
import org.glassfish.grizzly.sni.SNIConfig;
import org.glassfish.grizzly.sni.SNIFilter;
import org.glassfish.grizzly.sni.SNIServerConfigResolver;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.glassfish.grizzly.threadpool.DefaultWorkerThread;
import org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.glassfish.grizzly.utils.IdleTimeoutFilter;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.ConfigBeanProxy;

public class GenericGrizzlyListener
implements GrizzlyListener {
    private static final Logger LOGGER = Grizzly.logger(GenericGrizzlyListener.class);
    protected volatile String name;
    protected volatile InetAddress address;
    protected volatile int port;
    protected volatile PortRange portRange;
    protected NIOTransport transport;
    protected FilterChain rootFilterChain;
    private volatile ExecutorService workerExecutorService;
    private volatile ExecutorService auxExecutorService;
    private volatile DelayedExecutor delayedExecutor;
    private volatile long transactionTimeoutMillis = -1L;
    protected volatile boolean isAjpEnabled;
    protected volatile boolean isSpdyEnabled;
    protected volatile boolean isHttp2Enabled;
    protected volatile boolean skipHttp2;
    protected volatile boolean isWebSocketEnabled;
    protected volatile boolean isCometEnabled;

    @Override
    public String getName() {
        return this.name;
    }

    protected final void setName(String name) {
        this.name = name;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    protected final void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    protected void setPort(int port) {
        this.port = port;
    }

    @Override
    public PortRange getPortRange() {
        return this.portRange;
    }

    protected void setPortRange(PortRange portRange) {
        this.portRange = portRange;
    }

    private void bindTransport() throws IOException {
        if (this.portRange != null && this.transport instanceof TCPNIOTransport) {
            Connection<?> connection = this.transport.bind(this.address.getHostAddress(), this.portRange, false, ((TCPNIOTransport)TCPNIOTransport.class.cast(this.transport)).getServerConnectionBackLog());
            this.port = ((InetSocketAddress)InetSocketAddress.class.cast(connection.getLocalAddress())).getPort();
        } else {
            this.transport.bind(new InetSocketAddress(this.address, this.port));
        }
    }

    @Override
    public void start() throws IOException {
        this.startDelayedExecutor();
        this.transport.start();
    }

    @Override
    public void stop() throws IOException {
        this.stopDelayedExecutor();
        NIOTransport localTransport = this.transport;
        this.transport = null;
        if (localTransport != null) {
            localTransport.shutdownNow();
        }
        if (this.workerExecutorService != null) {
            ExecutorService localExecutorService = this.workerExecutorService;
            this.workerExecutorService = null;
            localExecutorService.shutdownNow();
        }
        this.rootFilterChain = null;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void processDynamicConfigurationChange(ServiceLocator habitat, PropertyChangeEvent[] events) {
    }

    @Override
    public <T> T getAdapter(Class<T> adapterClass) {
        return null;
    }

    public <E> List<E> getFilters(Class<E> clazz) {
        return GenericGrizzlyListener.getFilters(clazz, this.rootFilterChain, new ArrayList(2));
    }

    public org.glassfish.grizzly.Transport getTransport() {
        return this.transport;
    }

    public boolean isAjpEnabled() {
        return this.isAjpEnabled;
    }

    public boolean isSpdyEnabled() {
        return this.isSpdyEnabled;
    }

    public boolean isHttp2Enabled() {
        return this.isHttp2Enabled;
    }

    public boolean isWebSocketEnabled() {
        return this.isWebSocketEnabled;
    }

    public boolean isCometEnabled() {
        return this.isCometEnabled;
    }

    public static <E> List<E> getFilters(Class<E> clazz, FilterChain filterChain, List<E> filters) {
        for (Filter filter : filterChain) {
            if (clazz.isAssignableFrom(filter.getClass())) {
                filters.add(filter);
            }
            if (!PUFilter.class.isAssignableFrom(filter.getClass())) continue;
            Set<PUProtocol> puProtocols = ((PUFilter)filter).getProtocols();
            for (PUProtocol puProtocol : puProtocols) {
                GenericGrizzlyListener.getFilters(clazz, puProtocol.getFilterChain(), filters);
            }
        }
        return filters;
    }

    @Override
    public void configure(ServiceLocator habitat, NetworkListener networkListener) throws IOException {
        this.setName(networkListener.getName());
        this.setAddress(InetAddress.getByName(networkListener.getAddress()));
        this.setPort(Integer.parseInt(networkListener.getPort()));
        if (networkListener.getPortRange() != null) {
            this.setPortRange(PortRange.valueOf(networkListener.getPortRange()));
        }
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        this.configureTransport(networkListener, networkListener.findTransport(), filterChainBuilder);
        this.bindTransport();
        this.configureProtocol(habitat, networkListener, networkListener.findProtocol(), filterChainBuilder);
        this.configureThreadPool(habitat, networkListener, networkListener.findThreadPool());
        this.rootFilterChain = filterChainBuilder.build();
        this.transport.setProcessor(this.rootFilterChain);
    }

    protected void configureTransport(NetworkListener networkListener, Transport transportConfig, FilterChainBuilder filterChainBuilder) {
        int writeSize;
        String transportClassName = transportConfig.getClassname();
        if (TCPNIOTransport.class.getName().equals(transportClassName)) {
            this.transport = this.configureTCPTransport(transportConfig);
        } else if (UDPNIOTransport.class.getName().equals(transportClassName)) {
            this.transport = this.configureUDPTransport();
        } else {
            throw new GrizzlyConfigException("Unsupported transport type " + transportConfig.getName());
        }
        String selectorName = transportConfig.getSelectionKeyHandler();
        if (selectorName != null && GenericGrizzlyListener.getSelectionKeyHandlerByName(selectorName, transportConfig) != null && LOGGER.isLoggable(Level.INFO)) {
            LOGGER.warning("Element, selection-key-handler, has been deprecated and is effectively ignored by the runtime.");
        }
        if (!"heap".equalsIgnoreCase(transportConfig.getByteBufferType())) {
            this.transport.setMemoryManager(new ByteBufferManager(true, 65536, 32));
        }
        int acceptorThreads = Integer.parseInt(transportConfig.getAcceptorThreads());
        this.transport.setSelectorRunnersCount(acceptorThreads);
        int readSize = Integer.parseInt(transportConfig.getSocketReadBufferSize());
        if (readSize > 0) {
            this.transport.setReadBufferSize(readSize);
        }
        if ((writeSize = Integer.parseInt(transportConfig.getSocketWriteBufferSize())) > 0) {
            this.transport.setWriteBufferSize(writeSize);
        }
        ThreadPoolConfig kernelThreadPoolConfig = this.transport.getKernelThreadPoolConfig();
        kernelThreadPoolConfig.setPoolName(networkListener.getName() + "-kernel");
        if (acceptorThreads > 0) {
            kernelThreadPoolConfig.setCorePoolSize(acceptorThreads).setMaxPoolSize(acceptorThreads);
        }
        this.transport.setIOStrategy(GenericGrizzlyListener.loadIOStrategy(transportConfig.getIoStrategy()));
        this.transport.setNIOChannelDistributor(new RoundRobinConnectionDistributor(this.transport, Boolean.parseBoolean(transportConfig.getDedicatedAcceptorEnabled())));
        filterChainBuilder.add(new TransportFilter());
    }

    protected NIOTransport configureTCPTransport(Transport transportConfig) {
        TCPNIOTransport tcpTransport = this.configureDefaultThreadPoolConfigs(TCPNIOTransportBuilder.newInstance().build());
        tcpTransport.setTcpNoDelay(Boolean.parseBoolean(transportConfig.getTcpNoDelay()));
        tcpTransport.setLinger(Integer.parseInt(transportConfig.getLinger()));
        tcpTransport.setWriteTimeout(Long.parseLong(transportConfig.getWriteTimeoutMillis()), TimeUnit.MILLISECONDS);
        tcpTransport.setReadTimeout(Long.parseLong(transportConfig.getReadTimeoutMillis()), TimeUnit.MILLISECONDS);
        tcpTransport.setServerConnectionBackLog(Integer.parseInt(transportConfig.getMaxConnectionsCount()));
        return tcpTransport;
    }

    protected NIOTransport configureUDPTransport() {
        return this.configureDefaultThreadPoolConfigs(UDPNIOTransportBuilder.newInstance().build());
    }

    protected <T extends NIOTransport> T configureDefaultThreadPoolConfigs(T transport) {
        transport.setKernelThreadPoolConfig(ThreadPoolConfig.defaultConfig());
        transport.setWorkerThreadPoolConfig(ThreadPoolConfig.defaultConfig());
        return transport;
    }

    protected void configureProtocol(ServiceLocator habitat, NetworkListener networkListener, Protocol protocol, FilterChainBuilder filterChainBuilder) {
        if (Boolean.valueOf(protocol.getSecurityEnabled()).booleanValue()) {
            GenericGrizzlyListener.configureSsl(habitat, GenericGrizzlyListener.getSsl(protocol), filterChainBuilder);
        }
        this.configureSubProtocol(habitat, networkListener, protocol, filterChainBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureSubProtocol(ServiceLocator habitat, NetworkListener networkListener, Protocol protocol, FilterChainBuilder filterChainBuilder) {
        if (protocol.getHttp() != null) {
            Http http = protocol.getHttp();
            this.configureHttpProtocol(habitat, networkListener, http, filterChainBuilder, Boolean.valueOf(protocol.getSecurityEnabled()));
        } else if (protocol.getPortUnification() != null) {
            PortUnification pu = protocol.getPortUnification();
            String puFilterClassname = pu.getClassname();
            PUFilter puFilter = null;
            if (puFilterClassname != null) {
                try {
                    puFilter = Utils.newInstance(habitat, PUFilter.class, puFilterClassname, puFilterClassname);
                    GenericGrizzlyListener.configureElement(habitat, networkListener, pu, puFilter);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Can not initialize port unification filter: " + puFilterClassname + " default filter will be used instead", e);
                }
            }
            if (puFilter == null) {
                puFilter = new PUFilter();
            }
            List<ProtocolFinder> findersConfig = pu.getProtocolFinder();
            for (ProtocolFinder finderConfig : findersConfig) {
                String finderClassname = finderConfig.getClassname();
                try {
                    org.glassfish.grizzly.portunif.ProtocolFinder protocolFinder = Utils.newInstance(habitat, org.glassfish.grizzly.portunif.ProtocolFinder.class, finderClassname, finderClassname);
                    GenericGrizzlyListener.configureElement(habitat, networkListener, finderConfig, protocolFinder);
                    Protocol subProtocol = finderConfig.findProtocol();
                    if (subProtocol.getHttp() != null) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, "HTTP/2 (enabled by default) is unsupported with port unification and will be disabled for network listener {0}.", networkListener.getName());
                        }
                        this.skipHttp2 = true;
                    }
                    FilterChainBuilder subProtocolFilterChainBuilder = puFilter.getPUFilterChainBuilder();
                    if (Boolean.valueOf(subProtocol.getSecurityEnabled()).booleanValue()) {
                        PUFilter extraSslPUFilter = new PUFilter();
                        Filter addedSSLFilter = GenericGrizzlyListener.configureSsl(habitat, GenericGrizzlyListener.getSsl(subProtocol), subProtocolFilterChainBuilder);
                        subProtocolFilterChainBuilder.add(extraSslPUFilter);
                        FilterChainBuilder extraSslPUFilterChainBuilder = extraSslPUFilter.getPUFilterChainBuilder();
                        try {
                            extraSslPUFilterChainBuilder.add(addedSSLFilter);
                            this.configureSubProtocol(habitat, networkListener, subProtocol, extraSslPUFilterChainBuilder);
                        }
                        finally {
                            extraSslPUFilterChainBuilder.remove(addedSSLFilter);
                        }
                        extraSslPUFilter.register(protocolFinder, extraSslPUFilterChainBuilder.build());
                        puFilter.register(new SSLProtocolFinder(new SSLConfigurator(habitat, subProtocol.getSsl())), subProtocolFilterChainBuilder.build());
                        continue;
                    }
                    this.configureSubProtocol(habitat, networkListener, subProtocol, subProtocolFilterChainBuilder);
                    puFilter.register(protocolFinder, subProtocolFilterChainBuilder.build());
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Can not initialize sub protocol. Finder: " + finderClassname, e);
                }
            }
            filterChainBuilder.add(puFilter);
        } else if (protocol.getHttpRedirect() != null) {
            filterChainBuilder.add(this.createHttpServerCodecFilter());
            HttpRedirectFilter filter = new HttpRedirectFilter();
            filter.configure(habitat, networkListener, protocol.getHttpRedirect());
            filterChainBuilder.add(filter);
        } else {
            ProtocolChainInstanceHandler pcihConfig = protocol.getProtocolChainInstanceHandler();
            if (pcihConfig == null) {
                LOGGER.log(Level.WARNING, "Empty protocol declaration");
                return;
            }
            ProtocolChain filterChainConfig = pcihConfig.getProtocolChain();
            for (ProtocolFilter filterConfig : filterChainConfig.getProtocolFilter()) {
                String filterClassname = filterConfig.getClassname();
                try {
                    Filter filter = this.loadFilter(habitat, filterConfig.getName(), filterClassname);
                    GenericGrizzlyListener.configureElement(habitat, networkListener, filterConfig, filter);
                    filterChainBuilder.add(filter);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Can not initialize protocol filter: " + filterClassname, e);
                    throw new IllegalStateException("Can not initialize protocol filter: " + filterClassname);
                }
            }
        }
    }

    protected static Filter configureSsl(final ServiceLocator habitat, final Ssl ssl, FilterChainBuilder filterChainBuilder) {
        final SSLConfigurator serverConfig = new SSLConfigurator(habitat, ssl);
        SSLBaseFilter sslFilter = null;
        if (Boolean.valueOf(ssl.getSniEnabled()).booleanValue()) {
            SNIFilter sniFilter = new SNIFilter(serverConfig, null, GenericGrizzlyListener.isRenegotiateOnClientAuthWant(ssl));
            sniFilter.setHandshakeTimeout(Long.parseLong(ssl.getHandshakeTimeoutMillis()), TimeUnit.MILLISECONDS);
            sniFilter.setServerSSLConfigResolver(new SNIServerConfigResolver(){

                @Override
                public SNIConfig resolve(Connection cnctn, String hostname) {
                    if (hostname == null) {
                        return SNIConfig.newServerConfig(serverConfig);
                    }
                    SSLConfigurator newConfigurator = new SSLConfigurator(habitat, ssl);
                    newConfigurator.setSNICertAlias(hostname);
                    return SNIConfig.newServerConfig(newConfigurator);
                }
            });
            sslFilter = sniFilter;
        } else {
            sslFilter = new SSLBaseFilter(serverConfig, GenericGrizzlyListener.isRenegotiateOnClientAuthWant(ssl));
            sslFilter.setHandshakeTimeout(Long.parseLong(ssl.getHandshakeTimeoutMillis()), TimeUnit.MILLISECONDS);
        }
        filterChainBuilder.add(sslFilter);
        return sslFilter;
    }

    private static boolean isRenegotiateOnClientAuthWant(Ssl ssl) {
        return ssl == null || Boolean.parseBoolean(ssl.getRenegotiateOnClientAuthWant());
    }

    private static boolean configureElement(ServiceLocator habitat, NetworkListener networkListener, ConfigBeanProxy configuration, Object instance) {
        if (instance instanceof ConfigAwareElement) {
            ((ConfigAwareElement)instance).configure(habitat, networkListener, configuration);
            return true;
        }
        return false;
    }

    protected void configureThreadPool(ServiceLocator habitat, NetworkListener networkListener, ThreadPool threadPool) {
        String classname = threadPool.getClassname();
        if (classname != null && !"org.glassfish.grizzly.threadpool.GrizzlyExecutorService".equals(classname)) {
            try {
                ExecutorService customThreadPool = Utils.newInstance(habitat, ExecutorService.class, classname, classname);
                if (customThreadPool != null) {
                    if (!GenericGrizzlyListener.configureElement(habitat, networkListener, threadPool, customThreadPool)) {
                        LOGGER.log(Level.INFO, "The ThreadPool configuration bean can not be passed to the custom thread-pool: {0} instance, because it's not {1}.", new Object[]{classname, ConfigAwareElement.class.getName()});
                    }
                    this.workerExecutorService = customThreadPool;
                    this.transport.setWorkerThreadPool(customThreadPool);
                    return;
                }
                LOGGER.log(Level.WARNING, "Can not initalize custom thread pool: {0}", classname);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Can not initalize custom thread pool: " + classname, t);
            }
        }
        try {
            this.workerExecutorService = GrizzlyExecutorService.createInstance(this.configureThreadPoolConfig(networkListener, threadPool));
            this.transport.setWorkerThreadPool(this.workerExecutorService);
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.WARNING, "Invalid thread-pool attribute", ex);
        }
    }

    protected ThreadPoolConfig configureThreadPoolConfig(NetworkListener networkListener, ThreadPool threadPool) {
        int maxQueueSize = threadPool.getMaxQueueSize() == null ? Integer.MAX_VALUE : Integer.parseInt(threadPool.getMaxQueueSize());
        int minThreads = Integer.parseInt(threadPool.getMinThreadPoolSize());
        int maxThreads = Integer.parseInt(threadPool.getMaxThreadPoolSize());
        int timeout = Integer.parseInt(threadPool.getIdleThreadTimeoutSeconds());
        ThreadPoolConfig poolConfig = ThreadPoolConfig.defaultConfig();
        poolConfig.setPoolName(networkListener.getThreadPool() + "::" + networkListener.getName());
        poolConfig.setCorePoolSize(minThreads);
        poolConfig.setMaxPoolSize(maxThreads);
        poolConfig.setQueueLimit(maxQueueSize);
        poolConfig.setInitialClassLoader(this.getClass().getClassLoader());
        poolConfig.setKeepAliveTime(timeout < 0 ? Long.MAX_VALUE : (long)timeout, TimeUnit.SECONDS);
        if (this.transactionTimeoutMillis > 0L && !Utils.isDebugVM()) {
            poolConfig.setTransactionTimeout(this.obtainDelayedExecutor(), this.transactionTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        return poolConfig;
    }

    private DelayedExecutor obtainDelayedExecutor() {
        if (this.delayedExecutor != null) {
            return this.delayedExecutor;
        }
        final AtomicInteger threadCounter = new AtomicInteger();
        this.auxExecutorService = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                DefaultWorkerThread newThread = new DefaultWorkerThread(GenericGrizzlyListener.this.transport.getAttributeBuilder(), GenericGrizzlyListener.this.getName() + "-expirer(" + threadCounter.incrementAndGet() + ")", null, r);
                newThread.setDaemon(true);
                return newThread;
            }
        });
        this.delayedExecutor = new DelayedExecutor(this.auxExecutorService);
        return this.delayedExecutor;
    }

    protected void startDelayedExecutor() {
        if (this.delayedExecutor != null) {
            this.delayedExecutor.start();
        }
    }

    protected void stopDelayedExecutor() {
        if (this.delayedExecutor != null) {
            DelayedExecutor localDelayedExecutor = this.delayedExecutor;
            this.delayedExecutor = null;
            if (localDelayedExecutor != null) {
                localDelayedExecutor.stop();
                localDelayedExecutor.destroy();
            }
            ExecutorService localThreadPool = this.auxExecutorService;
            this.auxExecutorService = null;
            if (localThreadPool != null) {
                localThreadPool.shutdownNow();
            }
        }
    }

    protected void configureHttpProtocol(ServiceLocator habitat, NetworkListener networkListener, Http http, FilterChainBuilder filterChainBuilder, boolean secure) {
        this.transactionTimeoutMillis = Long.parseLong(http.getRequestTimeoutSeconds()) * 1000L;
        filterChainBuilder.add(new IdleTimeoutFilter(this.obtainDelayedExecutor(), this.getTimeoutSeconds(http), TimeUnit.SECONDS));
        HttpServerFilter httpServerFilter = this.createHttpServerCodecFilter(http);
        httpServerFilter.setRemoveHandledContentEncodingHeaders(true);
        Set<ContentEncoding> contentEncodings = this.configureContentEncodings(http);
        for (ContentEncoding contentEncoding : contentEncodings) {
            httpServerFilter.addContentEncoding(contentEncoding);
        }
        filterChainBuilder.add(httpServerFilter);
        org.glassfish.grizzly.http.server.filecache.FileCache fileCache = this.configureHttpFileCache(http.getFileCache());
        fileCache.initialize(this.obtainDelayedExecutor());
        FileCacheFilter fileCacheFilter = new FileCacheFilter(fileCache);
        filterChainBuilder.add(fileCacheFilter);
        this.configureHSTSSupport(habitat, http.getParent().getSsl(), filterChainBuilder);
        org.glassfish.grizzly.http.server.HttpServerFilter webServerFilter = new org.glassfish.grizzly.http.server.HttpServerFilter(this.getHttpServerFilterConfiguration(http), this.obtainDelayedExecutor());
        HttpHandler httpHandler = this.getHttpHandler();
        httpHandler.setAllowEncodedSlash(GrizzlyConfig.toBoolean(http.getEncodedSlashEnabled()));
        webServerFilter.setHttpHandler(httpHandler);
        filterChainBuilder.add(webServerFilter);
        this.configureHttp2Support(habitat, networkListener, http, filterChainBuilder, secure);
        this.configureCometSupport(habitat, networkListener, http, filterChainBuilder);
        this.configureWebSocketSupport(habitat, networkListener, http, filterChainBuilder);
        this.configureAjpSupport(habitat, networkListener, http, filterChainBuilder);
    }

    private int getTimeoutSeconds(Http http) {
        int timeoutSeconds = Integer.parseInt(http.getTimeoutSeconds());
        return timeoutSeconds == 0 ? -1 : timeoutSeconds;
    }

    protected void configureHttp2Support(ServiceLocator locator, NetworkListener listener, Http httpElement, FilterChainBuilder builder, boolean secure) {
        this.isHttp2Enabled = false;
        if (!this.skipHttp2 && httpElement != null && Boolean.parseBoolean(httpElement.getHttp2Enabled())) {
            try {
                Http2AddOn http2Addon = new Http2AddOn(Http2Configuration.builder().maxConcurrentStreams(Integer.parseInt(httpElement.getHttp2MaxConcurrentStreams())).initialWindowSize(Integer.parseInt(httpElement.getHttp2InitialWindowSizeInBytes())).maxFramePayloadSize(Integer.parseInt(httpElement.getHttp2MaxFramePayloadSizeInBytes())).maxHeaderListSize(Integer.parseInt(httpElement.getHttp2MaxHeaderListSizeInBytes())).streamsHighWaterMark(Float.parseFloat(httpElement.getHttp2StreamsHighWaterMark())).cleanPercentage(Float.parseFloat(httpElement.getHttp2CleanPercentage())).cleanFrequencyCheck(Integer.parseInt(httpElement.getHttp2CleanFrequencyCheck())).disableCipherCheck(Boolean.valueOf(httpElement.getHttp2DisableCipherCheck())).enablePush(Boolean.parseBoolean(httpElement.getHttp2PushEnabled())).executorService(this.transport.getWorkerThreadPool()).build());
                http2Addon.setup(this.createMockListener(secure), builder);
                this.isHttp2Enabled = true;
            }
            catch (NoClassDefFoundError ex) {
                LOGGER.log(Level.WARNING, "Unable to construct HTTP/2 Addon", ex);
            }
        }
    }

    protected org.glassfish.grizzly.http.server.NetworkListener createMockListener(final boolean isSecure) {
        final TCPNIOTransport transportLocal = (TCPNIOTransport)this.transport;
        return new org.glassfish.grizzly.http.server.NetworkListener("mock"){

            @Override
            public TCPNIOTransport getTransport() {
                return transportLocal;
            }

            @Override
            public boolean isSecure() {
                return isSecure;
            }
        };
    }

    protected void configureCometSupport(ServiceLocator habitat, NetworkListener networkListener, Http http, FilterChainBuilder filterChainBuilder) {
        AddOn cometAddOn;
        if (GrizzlyConfig.toBoolean(http.getCometSupportEnabled()) && (cometAddOn = this.loadAddOn(habitat, "comet", "org.glassfish.grizzly.comet.CometAddOn")) != null) {
            GenericGrizzlyListener.configureElement(habitat, networkListener, http, cometAddOn);
            cometAddOn.setup(null, filterChainBuilder);
            this.isCometEnabled = true;
        }
    }

    protected void configureWebSocketSupport(ServiceLocator habitat, NetworkListener listener, Http http, FilterChainBuilder filterChainBuilder) {
        AddOn wsAddOn;
        boolean websocketsSupportEnabled = Boolean.parseBoolean(http.getWebsocketsSupportEnabled());
        if (websocketsSupportEnabled && (wsAddOn = this.loadAddOn(habitat, "websocket", "org.glassfish.grizzly.websockets.WebSocketAddOn")) != null) {
            block4: {
                if (!GenericGrizzlyListener.configureElement(habitat, listener, http, wsAddOn)) {
                    try {
                        Method m = wsAddOn.getClass().getDeclaredMethod("setTimeoutInSeconds", Long.TYPE);
                        m.invoke((Object)wsAddOn, Long.parseLong(http.getWebsocketsTimeoutSeconds()));
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                        LOGGER.log(Level.WARNING, e.toString(), e);
                    }
                }
            }
            wsAddOn.setup(null, filterChainBuilder);
            this.isWebSocketEnabled = true;
        }
    }

    protected void configureAjpSupport(ServiceLocator habitat, NetworkListener networkListener, Http http, FilterChainBuilder filterChainBuilder) {
        AddOn ajpAddOn;
        boolean jkSupportEnabled;
        boolean bl = jkSupportEnabled = http.getJkEnabled() != null ? Boolean.parseBoolean(http.getJkEnabled()) : Boolean.parseBoolean(networkListener.getJkEnabled());
        if (jkSupportEnabled && (ajpAddOn = this.loadAddOn(habitat, "ajp", "org.glassfish.grizzly.http.ajp.AjpAddOn")) != null) {
            GenericGrizzlyListener.configureElement(habitat, networkListener, http, ajpAddOn);
            ajpAddOn.setup(null, filterChainBuilder);
            this.isAjpEnabled = true;
        }
    }

    protected Filter configureHSTSSupport(ServiceLocator habitat, Ssl ssl, FilterChainBuilder filterChainBuilder) {
        if (ssl != null && Boolean.parseBoolean(ssl.getHstsEnabled())) {
            HSTSFilter hstsFilter = new HSTSFilter();
            hstsFilter.configure(habitat, (NetworkListener)null, ssl);
            filterChainBuilder.add(hstsFilter);
            return hstsFilter;
        }
        return null;
    }

    private AddOn loadAddOn(ServiceLocator habitat, String name, String addOnClassName) {
        return Utils.newInstance(habitat, AddOn.class, name, addOnClassName);
    }

    private AddOn loadAddOn(String addOnClassName, Class[] argTypes, Object ... args) {
        return Utils.newInstance(null, AddOn.class, this.name, addOnClassName, argTypes, args);
    }

    private Filter loadFilter(ServiceLocator habitat, String name, String filterClassName) {
        return Utils.newInstance(habitat, Filter.class, name, filterClassName);
    }

    private HttpServerFilter createHttpServerCodecFilter() {
        return this.createHttpServerCodecFilter(null);
    }

    private HttpServerFilter createHttpServerCodecFilter(Http http) {
        int maxRequestHeaders = 100;
        int maxResponseHeaders = 100;
        boolean isChunkedEnabled = true;
        int headerBufferLengthBytes = 8192;
        String defaultResponseType = null;
        if (http != null) {
            isChunkedEnabled = Boolean.parseBoolean(http.getChunkingEnabled());
            headerBufferLengthBytes = Integer.parseInt(http.getHeaderBufferLengthBytes());
            defaultResponseType = http.getDefaultResponseType();
            maxRequestHeaders = Integer.parseInt(http.getMaxRequestHeaders());
            maxResponseHeaders = Integer.parseInt(http.getMaxResponseHeaders());
        }
        return this.createHttpServerCodecFilter(http, isChunkedEnabled, headerBufferLengthBytes, defaultResponseType, this.configureKeepAlive(http), this.obtainDelayedExecutor(), maxRequestHeaders, maxResponseHeaders);
    }

    protected HttpServerFilter createHttpServerCodecFilter(Http http, boolean isChunkedEnabled, int headerBufferLengthBytes, String defaultResponseType, KeepAlive keepAlive, DelayedExecutor delayedExecutor, int maxRequestHeaders, int maxResponseHeaders) {
        HttpServerFilter httpCodecFilter = new HttpServerFilter(isChunkedEnabled, headerBufferLengthBytes, defaultResponseType, keepAlive, delayedExecutor, maxRequestHeaders, maxResponseHeaders);
        if (http != null) {
            httpCodecFilter.setMaxPayloadRemainderToSkip(Integer.parseInt(http.getMaxSwallowingInputBytes()));
            httpCodecFilter.setAllowPayloadForUndefinedHttpMethods(Boolean.parseBoolean(http.getAllowPayloadForUndefinedHttpMethods()));
        }
        return httpCodecFilter;
    }

    protected ServerFilterConfiguration getHttpServerFilterConfiguration(Http http) {
        int maxRequestParameters;
        ServerFilterConfiguration serverFilterConfiguration = new ServerFilterConfiguration();
        String scheme = http.getScheme();
        String schemeMapping = http.getSchemeMapping();
        String remoteUserMapping = http.getRemoteUserMapping();
        if (scheme != null || schemeMapping != null || remoteUserMapping != null) {
            BackendConfiguration backendConfiguration = new BackendConfiguration();
            if (schemeMapping == null) {
                backendConfiguration.setScheme(scheme);
            } else {
                backendConfiguration.setSchemeMapping(schemeMapping);
            }
            backendConfiguration.setRemoteUserMapping(remoteUserMapping);
            serverFilterConfiguration.setBackendConfiguration(backendConfiguration);
        }
        serverFilterConfiguration.setPassTraceRequest(true);
        serverFilterConfiguration.setTraceEnabled(Boolean.valueOf(http.getTraceEnabled()));
        try {
            maxRequestParameters = Integer.parseInt(http.getMaxRequestParameters());
        }
        catch (NumberFormatException nfe) {
            maxRequestParameters = 10000;
        }
        serverFilterConfiguration.setMaxRequestParameters(maxRequestParameters);
        serverFilterConfiguration.setMaxPostSize(Integer.parseInt(http.getMaxPostSizeBytes()));
        serverFilterConfiguration.setMaxFormPostSize(Integer.parseInt(http.getMaxFormPostSizeBytes()));
        serverFilterConfiguration.setMaxBufferedPostSize(Integer.parseInt(http.getMaxSavePostSizeBytes()));
        return serverFilterConfiguration;
    }

    protected HttpHandler getHttpHandler() {
        return new StaticHttpHandler(new String[]{"."});
    }

    protected org.glassfish.grizzly.http.server.filecache.FileCache configureHttpFileCache(FileCache cache) {
        org.glassfish.grizzly.http.server.filecache.FileCache fileCache = new org.glassfish.grizzly.http.server.filecache.FileCache();
        if (cache != null) {
            fileCache.setEnabled(GrizzlyConfig.toBoolean(cache.getEnabled()));
            fileCache.setSecondsMaxAge(Integer.parseInt(cache.getMaxAgeSeconds()));
            fileCache.setMaxCacheEntries(Integer.parseInt(cache.getMaxFilesCount()));
            fileCache.setMaxLargeFileCacheSize(Integer.parseInt(cache.getMaxCacheSizeBytes()));
        } else {
            fileCache.setEnabled(false);
        }
        return fileCache;
    }

    protected KeepAlive configureKeepAlive(Http http) {
        int timeoutInSeconds = 60;
        int maxConnections = 256;
        if (http != null) {
            String msg;
            try {
                timeoutInSeconds = Integer.parseInt(http.getTimeoutSeconds());
            }
            catch (NumberFormatException ex) {
                msg = "pewebcontainer.invalidKeepAliveTimeout";
                msg = MessageFormat.format(msg, http.getTimeoutSeconds(), Integer.toString(timeoutInSeconds));
                LOGGER.log(Level.WARNING, msg, ex);
            }
            try {
                maxConnections = Integer.parseInt(http.getMaxConnections());
            }
            catch (NumberFormatException ex) {
                msg = "pewebcontainer.invalidKeepAliveMaxConnections";
                msg = MessageFormat.format(msg, http.getMaxConnections(), Integer.toString(maxConnections));
                LOGGER.log(Level.WARNING, msg, ex);
            }
        }
        KeepAlive keepAlive = new KeepAlive();
        keepAlive.setIdleTimeoutInSeconds(timeoutInSeconds);
        keepAlive.setMaxRequestsCount(maxConnections);
        return keepAlive;
    }

    protected Set<ContentEncoding> configureContentEncodings(Http http) {
        return this.configureCompressionEncodings(http);
    }

    protected Set<ContentEncoding> configureCompressionEncodings(Http http) {
        CompressionConfig.CompressionMode compressionMode;
        String mode = http.getCompression();
        int compressionMinSize = Integer.parseInt(http.getCompressionMinSizeBytes());
        try {
            compressionMode = CompressionConfig.CompressionMode.fromString(mode);
        }
        catch (IllegalArgumentException e) {
            try {
                compressionMode = CompressionConfig.CompressionMode.ON;
                compressionMinSize = Integer.parseInt(mode);
            }
            catch (Exception ignore) {
                compressionMode = CompressionConfig.CompressionMode.OFF;
            }
        }
        String compressableMimeTypesString = http.getCompressableMimeType();
        String noCompressionUserAgentsString = http.getNoCompressionUserAgents();
        String[] compressableMimeTypes = compressableMimeTypesString != null ? compressableMimeTypesString.split(",") : new String[]{};
        String[] noCompressionUserAgents = noCompressionUserAgentsString != null ? noCompressionUserAgentsString.split(",") : new String[]{};
        GZipContentEncoding gzipContentEncoding = new GZipContentEncoding(512, 512, new CompressionEncodingFilter(compressionMode, compressionMinSize, compressableMimeTypes, noCompressionUserAgents, GZipContentEncoding.getGzipAliases(), compressionMode != CompressionConfig.CompressionMode.OFF));
        LZMAContentEncoding lzmaEncoding = new LZMAContentEncoding(new CompressionEncodingFilter(compressionMode, compressionMinSize, compressableMimeTypes, noCompressionUserAgents, LZMAContentEncoding.getLzmaAliases(), compressionMode != CompressionConfig.CompressionMode.OFF));
        HashSet<ContentEncoding> set = new HashSet<ContentEncoding>(2);
        set.add(gzipContentEncoding);
        set.add(lzmaEncoding);
        return set;
    }

    private static IOStrategy loadIOStrategy(String classname) {
        Class<WorkerThreadIOStrategy> strategy;
        if (classname == null) {
            strategy = WorkerThreadIOStrategy.class;
        } else {
            try {
                strategy = Utils.loadClass(classname);
            }
            catch (Exception e) {
                strategy = WorkerThreadIOStrategy.class;
            }
        }
        try {
            Method m = strategy.getMethod("getInstance", new Class[0]);
            return (IOStrategy)m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not initialize IOStrategy: " + strategy + ". Error: " + e);
        }
    }

    private static Ssl getSsl(Protocol protocol) {
        Ssl ssl = protocol.getSsl();
        if (ssl == null) {
            ssl = (Ssl)DefaultProxy.createDummyProxy(protocol, Ssl.class);
        }
        return ssl;
    }

    private static SelectionKeyHandler getSelectionKeyHandlerByName(String name, Transport transportConfig) {
        Transports transports = transportConfig.getParent();
        List<SelectionKeyHandler> handlers = transports.getSelectionKeyHandler();
        if (!handlers.isEmpty()) {
            for (SelectionKeyHandler handler : handlers) {
                if (!handler.getName().equals(name)) continue;
                return handler;
            }
        }
        return null;
    }
}

