/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.enterprise.concurrent.ContextService;
import javax.enterprise.concurrent.ManagedExecutorService;
import org.glassfish.enterprise.concurrent.AbstractManagedThread;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedExecutorCompletionService;
import org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl;
import org.glassfish.enterprise.concurrent.internal.ManagedFutureTask;
import org.glassfish.enterprise.concurrent.spi.ContextSetupProvider;

public abstract class AbstractManagedExecutorService
extends AbstractExecutorService
implements ManagedExecutorService {
    protected final String name;
    protected final ContextSetupProvider contextSetupProvider;
    protected final ContextServiceImpl contextService;
    protected final ManagedThreadFactoryImpl managedThreadFactory;
    protected RejectPolicy rejectPolicy;
    protected final boolean contextualCallback;
    protected boolean longRunningTasks;

    public AbstractManagedExecutorService(String name, ManagedThreadFactoryImpl managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, ContextServiceImpl contextService, ContextSetupProvider contextCallback, RejectPolicy rejectPolicy) {
        this.name = name;
        this.contextSetupProvider = contextCallback;
        this.contextService = contextService;
        this.rejectPolicy = rejectPolicy;
        this.contextualCallback = false;
        this.longRunningTasks = longRunningTasks;
        if (managedThreadFactory == null) {
            managedThreadFactory = new ManagedThreadFactoryImpl(name + "-ManagedThreadFactory", null, 5);
        }
        managedThreadFactory.setHungTaskThreshold(hungTaskThreshold);
        this.managedThreadFactory = managedThreadFactory;
    }

    protected <T> T doInvokeAny(Collection<? extends Callable<T>> tasks, boolean timed, long nanos) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutionException ee;
        ArrayList futures;
        block17: {
            if (tasks == null) {
                throw new NullPointerException();
            }
            int ntasks = tasks.size();
            if (ntasks == 0) {
                throw new IllegalArgumentException();
            }
            futures = new ArrayList(ntasks);
            ManagedExecutorCompletionService<T> ecs = new ManagedExecutorCompletionService<T>(this);
            ee = null;
            long lastTime = timed ? System.nanoTime() : 0L;
            Iterator<Callable<T>> it = tasks.iterator();
            futures.add(ecs.submit(it.next()));
            --ntasks;
            int active = 1;
            while (true) {
                Object now22;
                Future f;
                if ((f = ecs.poll()) == null) {
                    if (ntasks > 0) {
                        --ntasks;
                        futures.add(ecs.submit(it.next()));
                        ++active;
                    } else {
                        if (active == 0) break;
                        if (timed) {
                            f = ecs.poll(nanos, TimeUnit.NANOSECONDS);
                            if (f == null) {
                                throw new TimeoutException();
                            }
                            long now22 = System.nanoTime();
                            nanos -= now22 - lastTime;
                            lastTime = now22;
                        } else {
                            f = ecs.take();
                        }
                    }
                }
                if (f == null) continue;
                --active;
                try {
                    now22 = f.get();
                }
                catch (ExecutionException eex) {
                    ee = eex;
                    continue;
                }
                catch (RuntimeException rex) {
                    ee = new ExecutionException(rex);
                    continue;
                }
                return (T)now22;
                break;
            }
            if (ee != null) break block17;
            ee = new ExecutionException(null);
        }
        throw ee;
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
    }

    public ContextSetupProvider getContextSetupProvider() {
        return this.contextSetupProvider;
    }

    public ContextService getContextService() {
        return this.contextService;
    }

    public boolean isContextualCallback() {
        return this.contextualCallback;
    }

    public Collection<AbstractManagedThread> getHungThreads() {
        if (this.longRunningTasks) {
            return null;
        }
        ArrayList<AbstractManagedThread> hungThreads = null;
        Collection<AbstractManagedThread> allThreads = this.getThreads();
        if (allThreads != null) {
            long now = System.currentTimeMillis();
            for (AbstractManagedThread thread : allThreads) {
                if (!thread.isTaskHung(now)) continue;
                if (hungThreads == null) {
                    hungThreads = new ArrayList<AbstractManagedThread>();
                }
                hungThreads.add(thread);
            }
        }
        return hungThreads;
    }

    public ManagedThreadFactoryImpl getManagedThreadFactory() {
        return this.managedThreadFactory;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLongRunningTasks() {
        return this.longRunningTasks;
    }

    public RejectPolicy getRejectPolicy() {
        return this.rejectPolicy;
    }

    public String getObjectName() {
        return null;
    }

    public Collection<AbstractManagedThread> getThreads() {
        return this.managedThreadFactory.getThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (tasks == null) {
            throw new NullPointerException();
        }
        ArrayList<ManagedFutureTask<T>> futures = new ArrayList<ManagedFutureTask<T>>(tasks.size());
        boolean done = false;
        try {
            for (Callable<T> callable : tasks) {
                ManagedFutureTask<T> managedFutureTask = this.getNewTaskFor(callable);
                futures.add(managedFutureTask);
                this.executeManagedFutureTask(managedFutureTask);
            }
            for (Future future : futures) {
                if (future.isDone()) continue;
                try {
                    future.get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {}
            }
            done = true;
            ArrayList<ManagedFutureTask<T>> arrayList = futures;
            return arrayList;
        }
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (tasks == null || unit == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        boolean done = false;
        try {
            for (Callable<T> t : tasks) {
                futures.add(this.getNewTaskFor(t));
            }
            long lastTime = System.nanoTime();
            Iterator it = futures.iterator();
            while (it.hasNext()) {
                this.executeManagedFutureTask((ManagedFutureTask)it.next());
                long now = System.nanoTime();
                lastTime = now;
                if ((nanos -= now - lastTime) > 0L) continue;
                ArrayList<Future<T>> arrayList = futures;
                return arrayList;
            }
            for (Future future : futures) {
                if (future.isDone()) continue;
                if (nanos <= 0L) {
                    ArrayList<Future<T>> arrayList = futures;
                    return arrayList;
                }
                try {
                    future.get(nanos, TimeUnit.NANOSECONDS);
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {
                }
                catch (TimeoutException toe) {
                    ArrayList<Future<T>> arrayList = futures;
                    if (!done) {
                        for (Future future2 : futures) {
                            future2.cancel(true);
                        }
                    }
                    return arrayList;
                }
                long now = System.nanoTime();
                nanos -= now - lastTime;
                lastTime = now;
            }
            done = true;
            ArrayList<Future<T>> arrayList = futures;
            return arrayList;
        }
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        try {
            return this.doInvokeAny(tasks, false, 0L);
        }
        catch (TimeoutException cannotHappen) {
            assert (false);
            return null;
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doInvokeAny(tasks, true, unit.toNanos(timeout));
    }

    public boolean isEventProvider() {
        return true;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return true;
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ManagedFutureTask<Object> ftask = this.getNewTaskFor(task, null);
        this.executeManagedFutureTask(ftask);
        return ftask;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        ManagedFutureTask<T> ftask = this.getNewTaskFor(task, result);
        this.executeManagedFutureTask(ftask);
        return ftask;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ManagedFutureTask<T> ftask = this.getNewTaskFor(task);
        this.executeManagedFutureTask(ftask);
        return ftask;
    }

    protected abstract ExecutorService getThreadPoolExecutor();

    @Override
    public abstract void execute(Runnable var1);

    protected void executeManagedFutureTask(ManagedFutureTask<?> task) {
        task.submitted();
        this.getThreadPoolExecutor().execute(task);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.getThreadPoolExecutor().awaitTermination(timeout, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.getThreadPoolExecutor().isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.getThreadPoolExecutor().isTerminated();
    }

    @Override
    public void shutdown() {
        this.getThreadPoolExecutor().shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> pendingTasks = this.getThreadPoolExecutor().shutdownNow();
        for (Runnable r : pendingTasks) {
            if (!(r instanceof ManagedFutureTask)) continue;
            ((ManagedFutureTask)r).cancel(true);
        }
        return pendingTasks;
    }

    protected abstract <V> ManagedFutureTask<V> getNewTaskFor(Runnable var1, V var2);

    protected abstract <V> ManagedFutureTask<V> getNewTaskFor(Callable<V> var1);

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable r, T result) {
        return this.getNewTaskFor(r, result);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return this.getNewTaskFor(callable);
    }

    public abstract ManagedExecutorService getExecutorForTaskListener();

    public abstract long getTaskCount();

    public abstract long getCompletedTaskCount();

    public abstract int getCorePoolSize();

    public abstract int getActiveCount();

    public abstract long getKeepAliveTime();

    public abstract int getLargestPoolSize();

    public abstract int getMaximumPoolSize();

    public abstract int getPoolSize();

    public abstract BlockingQueue getBlockingQueue();

    public abstract RejectedExecutionHandler getRejectedExecutionHandler();

    public abstract ThreadFactory getThreadFactory();

    public static enum RejectPolicy {
        ABORT,
        RETRY_ABORT;

    }
}

