/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.Query;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.core.proxy.AMXProxyHandler;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.impl.mbean.ParentChildren;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.RegexUtil;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.admin.amx.util.jmx.ObjectNameQueryImpl;

public class QueryMgrImpl
extends AMXImplBase {
    public QueryMgrImpl(ObjectName parentObjectName) {
        super(parentObjectName, Query.class);
    }

    public ObjectName[] queryProps(String props) {
        return this.queryPattern(Util.newObjectNamePattern(this.getJMXDomain(), props));
    }

    public ObjectName[] queryTypes(Set<String> types) {
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        for (ObjectName objectName : this.queryAll()) {
            if (!types.contains(Util.getTypeProp(objectName))) continue;
            result.add(objectName);
        }
        return this.asArray(result);
    }

    public ObjectName[] queryType(String type) {
        return this.queryProps(Util.makeTypeProp(type));
    }

    public ObjectName[] queryName(String name) {
        return this.queryProps(Util.makeNameProp(name));
    }

    public ObjectName[] queryPattern(ObjectName pattern) {
        return this.asArray(JMXUtil.queryNames(this.getMBeanServer(), pattern, null));
    }

    public ObjectName[] queryTypeName(String type, String name) {
        return this.queryProps(Util.makeRequiredProps(type, name));
    }

    private static String[] convertToRegex(String[] wildExprs) {
        String[] regexExprs = null;
        if (wildExprs != null) {
            regexExprs = new String[wildExprs.length];
            for (int i = 0; i < wildExprs.length; ++i) {
                String regex;
                String expr = wildExprs[i];
                regexExprs[i] = regex = expr == null ? null : RegexUtil.wildcardToJavaRegex(expr);
            }
        }
        return regexExprs;
    }

    private Set<ObjectName> matchWild(Set<ObjectName> candidates, String[] wildKeys, String[] wildValues) {
        String[] regexNames = QueryMgrImpl.convertToRegex(wildKeys);
        String[] regexValues = QueryMgrImpl.convertToRegex(wildValues);
        ObjectNameQueryImpl query = new ObjectNameQueryImpl();
        return query.matchAll(candidates, regexNames, regexValues);
    }

    public ObjectName[] queryWildAll(String[] wildKeys, String[] wildValues) {
        ObjectName[] candidates = this.queryAll();
        Set<ObjectName> candidatesSet = SetUtil.newSet(candidates);
        return this.asArray(this.matchWild(candidatesSet, wildKeys, wildValues));
    }

    public ObjectName[] queryAll() {
        ObjectName pat = Util.newObjectNamePattern(this.getJMXDomain(), "");
        Set<ObjectName> names = JMXUtil.queryNames(this.getMBeanServer(), pat, null);
        return this.asArray(names);
    }

    private ObjectName[] asArray(Set<ObjectName> items) {
        return CollectionUtil.toArray(items, ObjectName.class);
    }

    public ObjectName[] getGlobalSingletons() {
        ObjectName[] all = this.queryAll();
        ArrayList<ObjectName> globalSingletons = new ArrayList<ObjectName>();
        ProxyFactory proxyFactory = this.getProxyFactory();
        for (ObjectName candidate : all) {
            MBeanInfo mbeanInfo = proxyFactory.getMBeanInfo(candidate);
            if (mbeanInfo == null || !AMXProxyHandler.globalSingleton(mbeanInfo)) continue;
            globalSingletons.add(candidate);
        }
        return CollectionUtil.toArray(globalSingletons, ObjectName.class);
    }

    public ObjectName getGlobalSingleton(String type) {
        ObjectName[] gs;
        for (ObjectName objectName : gs = this.getGlobalSingletons()) {
            if (!Util.getTypeProp(objectName).equals(type)) continue;
            return objectName;
        }
        return null;
    }

    public ObjectName[] queryDescendants(ObjectName parentObjectName) {
        AMXProxy parent = this.getProxyFactory().getProxy(parentObjectName);
        List<AMXProxy> items = ParentChildren.hierarchy(parent).asList();
        return Util.toObjectNamesArray(items);
    }
}

