/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public final class FileUtils {
    private FileUtils() {
    }

    public static String fileToString(File src) throws FileNotFoundException, IOException {
        return FileUtils.fileToString(src, 32768);
    }

    public static String fileToString(File src, int readBufferSize) throws FileNotFoundException, IOException {
        long length = src.length();
        if (length > 0x40000000L) {
            throw new IllegalArgumentException();
        }
        char[] readBuffer = new char[readBufferSize];
        StringBuilder result = new StringBuilder((int)length);
        try (FileReader in = new FileReader(src);){
            int numRead;
            while ((numRead = in.read(readBuffer, 0, readBufferSize)) >= 0) {
                result.append(readBuffer, 0, numRead);
            }
        }
        return result.toString();
    }

    public static void stringToFile(String s, File dest) throws IOException {
        try (FileWriter out = new FileWriter(dest);){
            out.write(s);
        }
    }
}

