/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import com.sun.messaging.jmq.util.LoggerWrapper;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class RuntimeFaultInjection {
    private LoggerWrapper logger = null;
    private Logger jlogger = null;
    private Set injections = Collections.synchronizedSet(new HashSet());
    private Map injectionSelectors = Collections.synchronizedMap(new HashMap());
    private Map injectionProps = Collections.synchronizedMap(new HashMap());
    private String shutdownMsg = "SHUTING DOWN BECAUSE OF FAULT ";
    private String haltMsg = "HALT BECAUSE OF FAULT ";
    public boolean FAULT_INJECTION = false;

    public void setProcessName(String name) {
        this.shutdownMsg = "SHUTING DOWN " + name + " BECAUSE OF FAULT ";
        this.haltMsg = "HALT " + name + " BECAUSE OF FAULT ";
    }

    protected void setLogger(Object l) {
        if (l instanceof LoggerWrapper) {
            this.logger = (LoggerWrapper)l;
        } else if (l instanceof Logger) {
            this.jlogger = (Logger)l;
        }
    }

    public void setFault(String fault, String selector) throws SelectorFormatException {
        this.setFault(fault, selector, null);
    }

    public void setFault(String fault, String selector, Map props) throws SelectorFormatException {
        this.logInfo("Setting Fault " + fault + "[ selector=" + selector + "], [props=" + props + "]");
        this.injections.add(fault);
        if (selector != null && selector.length() != 0) {
            Selector s = Selector.compile(selector);
            this.injectionSelectors.put(fault, s);
        }
        if (props != null) {
            this.injectionProps.put(fault, props);
        }
    }

    public void unsetFault(String fault) {
        this.logInfo("Removing Fault " + fault);
        this.injections.remove(fault);
        this.injectionSelectors.remove(fault);
        this.injectionProps.remove(fault);
    }

    public void setFaultInjection(boolean inject) {
        if (this.FAULT_INJECTION != inject) {
            if (inject) {
                this.logInfo("Turning on Fault Injection");
            } else {
                this.logInfo("Turning off Fault Injection");
            }
            this.FAULT_INJECTION = inject;
        }
    }

    private void logInjection(String fault, Selector sel) {
        String str = "Fault Injection: triggered " + fault;
        if (sel != null) {
            str = str + " selector [ " + sel.toString() + "]";
        }
        FaultInjectionException ex = new FaultInjectionException();
        ex.fillInStackTrace();
        this.logInfo(str, ex);
    }

    private Map checkFaultGetProps(String fault, Map props) {
        if (!this.FAULT_INJECTION) {
            return null;
        }
        boolean ok = this.checkFault(fault, props);
        if (!ok) {
            return null;
        }
        HashMap m = (HashMap)this.injectionProps.get(fault);
        if (m == null) {
            m = new HashMap();
        }
        return m;
    }

    public boolean checkFault(String fault, Map props) {
        return this.checkFault(fault, props, false);
    }

    private boolean checkFault(String fault, Map props, boolean onceOnly) {
        if (!this.FAULT_INJECTION) {
            return false;
        }
        if (this.injections.contains(fault)) {
            Selector s = (Selector)this.injectionSelectors.get(fault);
            if (s == null) {
                this.logInjection(fault, null);
                if (onceOnly) {
                    this.injections.remove(fault);
                }
                return true;
            }
            try {
                boolean match = s.match(props, null);
                if (match) {
                    this.logInjection(fault, s);
                    if (onceOnly) {
                        this.injections.remove(fault);
                    }
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                this.logWarn("Unable to apply fault ", ex);
                return false;
            }
        }
        return false;
    }

    public void checkFaultAndThrowIOException(String value, Map props) throws IOException {
        if (!this.FAULT_INJECTION) {
            return;
        }
        if (this.checkFault(value, props)) {
            IOException ex = new IOException("Fault Insertion: " + value);
            throw ex;
        }
    }

    public void checkFaultAndThrowException(String value, Map props, String ex_class) throws Exception {
        this.checkFaultAndThrowException(value, props, ex_class, false);
    }

    public void checkFaultAndThrowException(String value, Map props, String ex_class, boolean onceOnly) throws Exception {
        if (!this.FAULT_INJECTION) {
            return;
        }
        if (this.checkFault(value, props, onceOnly)) {
            Class<?> c = Class.forName(ex_class);
            Class[] paramTypes = new Class[]{String.class};
            Constructor<?> cons = c.getConstructor(paramTypes);
            Object[] paramArgs = new Object[]{"Fault Injection: " + value};
            Exception ex = (Exception)cons.newInstance(paramArgs);
            throw ex;
        }
    }

    public void checkFaultAndThrowError(String value, Map props) throws Error {
        if (!this.FAULT_INJECTION) {
            return;
        }
        if (this.checkFault(value, props)) {
            Error ex = new Error("Fault Insertion: " + value);
            throw ex;
        }
    }

    public void checkFaultAndExit(String value, Map props, int exitCode, boolean nice) {
        if (!this.FAULT_INJECTION) {
            return;
        }
        if (this.checkFault(value, props)) {
            if (nice) {
                this.logInfo(this.shutdownMsg + value);
                this.exit(exitCode);
            } else {
                this.logInfo(this.haltMsg + value);
                Runtime.getRuntime().halt(exitCode);
            }
        }
    }

    protected abstract void exit(int var1);

    protected abstract String sleepIntervalPropertyName();

    protected abstract int sleepIntervalDefault();

    public boolean checkFaultAndSleep(String value, Map props) {
        return this.checkFaultAndSleep(value, props, false);
    }

    public boolean checkFaultAndSleep(String value, Map props, boolean unsetFaultBeforeSleep) {
        if (!this.FAULT_INJECTION) {
            return false;
        }
        Map p = this.checkFaultGetProps(value, props);
        if (p == null) {
            return false;
        }
        String str = (String)p.get(this.sleepIntervalPropertyName());
        int secs = this.sleepIntervalDefault();
        if (str != null) {
            try {
                secs = Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (secs <= 0) {
            secs = this.sleepIntervalDefault();
        }
        if (unsetFaultBeforeSleep) {
            this.unsetFault(value);
        }
        this.logInfo("BEFORE SLEEP " + secs + "(seconds) BECAUSE OF FAULT " + value);
        try {
            Thread.sleep((long)secs * 1000L);
        }
        catch (Exception e) {
            this.logInfo("SLEEP " + secs + "(seconds) FAULT (" + value + ") interrupted: " + e.getMessage());
        }
        this.logInfo("AFTER SLEEP " + secs + "(seconds) BECAUSE OF FAULT " + value);
        return true;
    }

    private void logInfo(String msg) {
        this.logInfo(msg, null);
    }

    protected void logInfo(String msg, Throwable t) {
        if (this.logger != null) {
            this.logger.logInfo(msg, t);
        } else if (this.jlogger != null) {
            if (t == null) {
                this.jlogger.log(Level.INFO, msg);
            } else {
                this.jlogger.log(Level.INFO, msg, t);
            }
        }
    }

    protected void logWarn(String msg, Throwable t) {
        if (this.logger != null) {
            this.logger.logWarn(msg, t);
        } else if (this.jlogger != null) {
            if (t == null) {
                this.jlogger.log(Level.WARNING, msg);
            } else {
                this.jlogger.log(Level.WARNING, msg, t);
            }
        }
    }

    static class FaultInjectionException
    extends Exception {
        FaultInjectionException() {
        }

        @Override
        public String toString() {
            return "FaultInjectionTrace";
        }
    }
}

