/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import com.sun.enterprise.config.serverbeans.MonitoringService;
import fish.payara.monitoring.collect.MonitoringDataCollection;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.web.admin.monitor.JspStatsProvider;
import org.glassfish.web.admin.monitor.RequestStatsProvider;
import org.glassfish.web.admin.monitor.ServletInstanceStatsProvider;
import org.glassfish.web.admin.monitor.ServletStatsProvider;
import org.glassfish.web.admin.monitor.SessionStatsProvider;
import org.jvnet.hk2.annotations.Service;

@Service(name="web")
@Singleton
public class WebStatsProviderBootstrap
implements PostConstruct,
MonitoringDataSource {
    private static final String WEB_CONTAINER = "web-container";
    private static final String NODE_SEPARATOR = "/";
    @Inject
    private MonitoringService monitoringService;
    private ConcurrentMap<String, ConcurrentMap<String, Queue<Object>>> vsNameToStatsProviderMap = new ConcurrentHashMap<String, ConcurrentMap<String, Queue<Object>>>();
    private Queue<Object> webContainerStatsProviderQueue = new ConcurrentLinkedQueue<Object>();

    public void postConstruct() {
        this.registerWebStatsProviders();
    }

    private synchronized void registerWebStatsProviders() {
        JspStatsProvider jsp = new JspStatsProvider(null, null);
        RequestStatsProvider wsp = new RequestStatsProvider(null, null);
        ServletStatsProvider svsp = new ServletStatsProvider(null, null);
        SessionStatsProvider sssp = new SessionStatsProvider(null, null);
        StatsProviderManager.register((String)WEB_CONTAINER, (PluginPoint)PluginPoint.SERVER, (String)"web/jsp", (Object)jsp);
        StatsProviderManager.register((String)WEB_CONTAINER, (PluginPoint)PluginPoint.SERVER, (String)"web/request", (Object)wsp);
        StatsProviderManager.register((String)WEB_CONTAINER, (PluginPoint)PluginPoint.SERVER, (String)"web/servlet", (Object)svsp);
        StatsProviderManager.register((String)WEB_CONTAINER, (PluginPoint)PluginPoint.SERVER, (String)"web/session", (Object)sssp);
        this.webContainerStatsProviderQueue.add(jsp);
        this.webContainerStatsProviderQueue.add(wsp);
        this.webContainerStatsProviderQueue.add(svsp);
        this.webContainerStatsProviderQueue.add(sssp);
    }

    public void registerApplicationStatsProviders(String monitoringName, String vsName, List<String> servletNames) {
        Queue anotherQueue;
        String node = WebStatsProviderBootstrap.getNodeString(monitoringName, vsName);
        ConcurrentMap<String, ConcurrentLinkedQueue<Object>> statsProviderMap = (ConcurrentHashMap)this.vsNameToStatsProviderMap.get(vsName);
        Queue<SessionStatsProvider> statspList = null;
        if (statsProviderMap == null) {
            statsProviderMap = new ConcurrentHashMap();
            ConcurrentMap anotherMap = this.vsNameToStatsProviderMap.putIfAbsent(vsName, statsProviderMap);
            if (anotherMap != null) {
                statsProviderMap = anotherMap;
            }
        } else {
            statspList = (ConcurrentLinkedQueue<JspStatsProvider>)statsProviderMap.get(monitoringName);
        }
        if (statspList == null && (anotherQueue = (Queue)statsProviderMap.putIfAbsent(monitoringName, (ConcurrentLinkedQueue<Object>)(statspList = new ConcurrentLinkedQueue<JspStatsProvider>()))) != null) {
            statspList = anotherQueue;
        }
        JspStatsProvider jspStatsProvider = new JspStatsProvider(monitoringName, vsName);
        StatsProviderManager.register((String)WEB_CONTAINER, (PluginPoint)PluginPoint.APPLICATIONS, (String)node, (Object)jspStatsProvider);
        statspList.add((SessionStatsProvider)((Object)jspStatsProvider));
        ServletStatsProvider servletStatsProvider = new ServletStatsProvider(monitoringName, vsName);
        StatsProviderManager.register((String)WEB_CONTAINER, (PluginPoint)PluginPoint.APPLICATIONS, (String)node, (Object)servletStatsProvider);
        statspList.add((SessionStatsProvider)((Object)servletStatsProvider));
        SessionStatsProvider sessionStatsProvider = new SessionStatsProvider(monitoringName, vsName);
        StatsProviderManager.register((String)WEB_CONTAINER, (PluginPoint)PluginPoint.APPLICATIONS, (String)node, (Object)sessionStatsProvider);
        statspList.add(sessionStatsProvider);
        RequestStatsProvider websp = new RequestStatsProvider(monitoringName, vsName);
        StatsProviderManager.register((String)WEB_CONTAINER, (PluginPoint)PluginPoint.APPLICATIONS, (String)node, (Object)websp);
        for (String servletName : servletNames) {
            ServletInstanceStatsProvider servletInstanceStatsProvider = new ServletInstanceStatsProvider(servletName, monitoringName, vsName, servletStatsProvider);
            StatsProviderManager.register((String)WEB_CONTAINER, (PluginPoint)PluginPoint.APPLICATIONS, (String)WebStatsProviderBootstrap.getNodeString(monitoringName, vsName, servletName), (Object)servletInstanceStatsProvider);
            statspList.add((SessionStatsProvider)((Object)servletInstanceStatsProvider));
        }
        statspList.add((SessionStatsProvider)((Object)websp));
    }

    public void unregisterApplicationStatsProviders(String monitoringName, String vsName) {
        Map statsProviderMap = (Map)this.vsNameToStatsProviderMap.get(vsName);
        Queue statsProviders = (Queue)statsProviderMap.remove(monitoringName);
        for (Object statsProvider : statsProviders) {
            StatsProviderManager.unregister(statsProvider);
        }
        if (statsProviderMap.isEmpty()) {
            this.vsNameToStatsProviderMap.remove(vsName);
        }
    }

    private static String getNodeString(String moduleName, String ... others) {
        StringBuilder sb = new StringBuilder(moduleName);
        for (String other : others) {
            sb.append(NODE_SEPARATOR).append(other);
        }
        return sb.toString();
    }

    public void collect(MonitoringDataCollector collector) {
        MonitoringDataCollector web = collector.in((CharSequence)"web");
        if (!"true".equals(this.monitoringService.getMonitoringEnabled()) || !"HIGH".equals(this.monitoringService.getModuleMonitoringLevels().getWebContainer())) {
            return;
        }
        for (Object e : this.webContainerStatsProviderQueue) {
            web.collectObject(e, MonitoringDataCollection::collectObject);
        }
        for (ConcurrentMap concurrentMap : this.vsNameToStatsProviderMap.values()) {
            for (Map.Entry serverEntry : concurrentMap.entrySet()) {
                String monitoringName = (String)serverEntry.getKey();
                for (Object provider : (Queue)serverEntry.getValue()) {
                    if (!(provider instanceof RequestStatsProvider)) continue;
                    web.group((CharSequence)monitoringName).collectObject(provider, MonitoringDataCollection::collectObject);
                }
            }
        }
    }

    static {
        MonitoringDataCollection.register(CountStatistic.class, (collector, count) -> collector.collect((CharSequence)count.getName(), count.getCount()));
        MonitoringDataCollection.register(RangeStatistic.class, (collector, count) -> collector.collect((CharSequence)count.getName(), count.getCurrent()));
    }
}

