/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.config;

import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MembershipAdapter;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.replicatedmap.ReplicatedMap;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(value=10)
public class ClusteredConfig
extends MembershipAdapter {
    private static final String CONFIGURATION_PREFIX = "fish.payara.config:";
    @Inject
    private HazelcastCore hzCore;
    private UUID membershipListenerRegistrationId;
    private final Set<String> sharedConfigurations = ConcurrentHashMap.newKeySet();

    @PostConstruct
    public void postConstruct() {
        HazelcastInstance hzInstance = this.hzCore.getInstance();
        if (hzInstance != null) {
            this.membershipListenerRegistrationId = hzInstance.getCluster().addMembershipListener((MembershipListener)this);
        }
    }

    @PreDestroy
    public void preDestroy() {
        HazelcastInstance hzInstance = this.hzCore.getInstance();
        if (hzInstance != null && this.membershipListenerRegistrationId != null) {
            hzInstance.getCluster().removeMembershipListener(this.membershipListenerRegistrationId);
        }
    }

    public <T extends Number> T getSharedConfiguration(String name, T localValue, BiFunction<T, T, T> merge) {
        HazelcastInstance hzInstance = this.hzCore.getInstance();
        if (hzInstance == null) {
            return localValue;
        }
        String instance = this.instanceName(hzInstance.getCluster().getLocalMember());
        String mapName = CONFIGURATION_PREFIX + name;
        this.sharedConfigurations.add(mapName);
        ReplicatedMap map = hzInstance.getReplicatedMap(mapName);
        map.put((Object)instance, localValue);
        Object res = localValue;
        for (Number e : map.values()) {
            res = (Number)merge.apply(res, e);
        }
        return res;
    }

    public void clearSharedConfiguration(String name) {
        HazelcastInstance hzInstance = this.hzCore.getInstance();
        if (hzInstance != null) {
            String instance = this.instanceName(hzInstance.getCluster().getLocalMember());
            String mapName = CONFIGURATION_PREFIX + name;
            if (instance != null) {
                hzInstance.getReplicatedMap(mapName).remove((Object)instance);
            }
        }
    }

    public void memberRemoved(MembershipEvent event) {
        String instance = this.instanceName(event.getMember());
        for (String mapName : this.sharedConfigurations) {
            this.hzCore.getInstance().getReplicatedMap(mapName).remove((Object)instance);
        }
    }

    private String instanceName(Member member) {
        return this.hzCore.getAttribute(member.getUuid(), "GLASSFISH-INSTANCE");
    }
}

