/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid;

import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import fish.payara.security.openid.api.AccessTokenCallerPrincipal;
import fish.payara.security.openid.api.AccessTokenCredential;
import fish.payara.security.openid.controller.JWTValidator;
import fish.payara.security.openid.controller.TokenClaimsSetVerifier;
import fish.payara.security.openid.domain.AccessTokenImpl;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import fish.payara.security.openid.domain.OpenIdContextImpl;
import java.text.ParseException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.security.enterprise.CallerPrincipal;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStore;

@ApplicationScoped
@Typed(value={AccessTokenIdentityStore.class})
public class AccessTokenIdentityStore
implements IdentityStore {
    private static final Logger LOGGER = Logger.getLogger(AccessTokenIdentityStore.class.getName());
    @Inject
    OpenIdContextImpl context;
    @Inject
    OpenIdConfiguration configuration;
    @Inject
    JWTValidator validator;
    @Inject
    BeanManager beanManager;

    public Set<IdentityStore.ValidationType> validationTypes() {
        return Collections.singleton(IdentityStore.ValidationType.VALIDATE);
    }

    public CredentialValidationResult validate(AccessTokenCredential credential) {
        try {
            AccessTokenImpl accessToken = AccessTokenImpl.forBearerToken(this.configuration, credential.getAccessToken(), new BearerVerifier(this.configuration), this.validator);
            if (this.isSessionActive()) {
                this.context.setAccessToken(accessToken);
                this.context.setCallerName(accessToken.getJwtClaims().getStringClaim(this.configuration.getClaimsConfiguration().getCallerNameClaim()).orElse(accessToken.getJwtClaims().getSubject().orElse(null)));
            }
            return new CredentialValidationResult((CallerPrincipal)new AccessTokenCallerPrincipal(accessToken, this.context::getClaims));
        }
        catch (RuntimeException | ParseException e) {
            LOGGER.log(Level.WARNING, "Cannot parse access token " + credential.getAccessToken(), e);
            return CredentialValidationResult.INVALID_RESULT;
        }
    }

    private boolean isSessionActive() {
        try {
            return this.beanManager.getContext(SessionScoped.class).isActive();
        }
        catch (ContextNotActiveException notActive) {
            return false;
        }
    }

    static class BearerVerifier
    extends TokenClaimsSetVerifier {
        public BearerVerifier(OpenIdConfiguration configuration) {
            super(configuration);
        }

        @Override
        public void verify(JWTClaimsSet claims, SecurityContext c) throws BadJWTException {
            TokenClaimsSetVerifier.StandardVerifications standardVerifications = new TokenClaimsSetVerifier.StandardVerifications(this.configuration, claims);
            standardVerifications.requireSameIssuer();
            standardVerifications.requireSubject();
            standardVerifications.requireValidTimestamp();
        }

        @Override
        public void verify(JWTClaimsSet jwtcs) throws BadJWTException {
        }
    }
}

