/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.controller;

import fish.payara.security.annotations.ClaimsDefinition;
import fish.payara.security.annotations.LogoutDefinition;
import fish.payara.security.annotations.OpenIdAuthenticationDefinition;
import fish.payara.security.openid.OpenIdUtil;
import fish.payara.security.openid.api.OpenIdConstant;
import fish.payara.security.openid.controller.CacheKey;
import fish.payara.security.openid.controller.ProviderMetadataContoller;
import fish.payara.security.openid.domain.ClaimsConfiguration;
import fish.payara.security.openid.domain.LogoutConfiguration;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import fish.payara.security.openid.domain.OpenIdProviderMetadata;
import fish.payara.security.openid.domain.OpenIdTokenEncryptionMetadata;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.json.JsonObject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@ApplicationScoped
public class ConfigurationController
implements Serializable {
    @Inject
    private ProviderMetadataContoller providerMetadataContoller;
    private static final String SPACE_SEPARATOR = " ";
    private volatile transient LastBuiltConfig lastBuiltConfig;

    @Produces
    @RequestScoped
    public OpenIdConfiguration produceConfiguration(OpenIdAuthenticationDefinition definition) {
        OpenIdConfiguration cached;
        if (this.lastBuiltConfig == null) {
            this.lastBuiltConfig = new LastBuiltConfig(null, null);
        }
        if ((cached = this.lastBuiltConfig.cachedConfiguration(definition)) != null) {
            return cached;
        }
        OpenIdConfiguration config = this.buildConfig(definition);
        this.lastBuiltConfig = new LastBuiltConfig(definition, config);
        return config;
    }

    public OpenIdConfiguration buildConfig(OpenIdAuthenticationDefinition definition) {
        URL jwksURL;
        Config provider = ConfigProvider.getConfig();
        String providerURI = OpenIdUtil.getConfiguredValue(String.class, definition.providerURI(), provider, "payara.security.openid.providerURI");
        fish.payara.security.annotations.OpenIdProviderMetadata providerMetadata = definition.providerMetadata();
        JsonObject providerDocument = this.providerMetadataContoller.getDocument(providerURI);
        String authorizationEndpoint = OpenIdUtil.isEmpty(providerMetadata.authorizationEndpoint()) && providerDocument.containsKey((Object)"authorization_endpoint") ? OpenIdUtil.getConfiguredValue(String.class, providerDocument.getString("authorization_endpoint"), provider, "payara.security.openid.provider.authorizationEndpoint") : OpenIdUtil.getConfiguredValue(String.class, providerMetadata.authorizationEndpoint(), provider, "payara.security.openid.provider.authorizationEndpoint");
        String tokenEndpoint = OpenIdUtil.isEmpty(providerMetadata.tokenEndpoint()) && providerDocument.containsKey((Object)"token_endpoint") ? OpenIdUtil.getConfiguredValue(String.class, providerDocument.getString("token_endpoint"), provider, "payara.security.openid.provider.tokenEndpoint") : OpenIdUtil.getConfiguredValue(String.class, providerMetadata.tokenEndpoint(), provider, "payara.security.openid.provider.tokenEndpoint");
        String userinfoEndpoint = OpenIdUtil.isEmpty(providerMetadata.userinfoEndpoint()) && providerDocument.containsKey((Object)"userinfo_endpoint") ? OpenIdUtil.getConfiguredValue(String.class, providerDocument.getString("userinfo_endpoint"), provider, "payara.security.openid.provider.userinfoEndpoint") : OpenIdUtil.getConfiguredValue(String.class, providerMetadata.userinfoEndpoint(), provider, "payara.security.openid.provider.userinfoEndpoint");
        String endSessionEndpoint = OpenIdUtil.isEmpty(providerMetadata.endSessionEndpoint()) && providerDocument.containsKey((Object)"end_session_endpoint") ? OpenIdUtil.getConfiguredValue(String.class, providerDocument.getString("end_session_endpoint"), provider, "payara.security.openid.provider.endSessionEndpoint") : OpenIdUtil.getConfiguredValue(String.class, providerMetadata.endSessionEndpoint(), provider, "payara.security.openid.provider.endSessionEndpoint");
        String jwksURI = OpenIdUtil.isEmpty(providerMetadata.jwksURI()) && providerDocument.containsKey((Object)"jwks_uri") ? OpenIdUtil.getConfiguredValue(String.class, providerDocument.getString("jwks_uri"), provider, "payara.security.openid.provider.jwksURI") : OpenIdUtil.getConfiguredValue(String.class, providerMetadata.jwksURI(), provider, "payara.security.openid.provider.jwksURI");
        try {
            jwksURL = new URL(jwksURI);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("jwksURI is invalid", ex);
        }
        String clientId = OpenIdUtil.getConfiguredValue(String.class, definition.clientId(), provider, "payara.security.openid.clientId");
        char[] clientSecret = OpenIdUtil.getConfiguredValue(String.class, definition.clientSecret(), provider, "payara.security.openid.clientSecret").toCharArray();
        String redirectURI = OpenIdUtil.getConfiguredValue(String.class, definition.redirectURI(), provider, "payara.security.openid.redirectURI");
        String scopes = Arrays.stream(definition.scope()).collect(Collectors.joining(SPACE_SEPARATOR));
        scopes = OpenIdUtil.getConfiguredValue(String.class, scopes, provider, "payara.security.openid.scope");
        if (OpenIdUtil.isEmpty(scopes)) {
            scopes = "openid";
        } else if (!scopes.contains("openid")) {
            scopes = "openid " + scopes;
        }
        String responseType = OpenIdUtil.getConfiguredValue(String.class, definition.responseType(), provider, "payara.security.openid.responseType");
        responseType = Arrays.stream(responseType.trim().split(SPACE_SEPARATOR)).map(String::toLowerCase).sorted().collect(Collectors.joining(SPACE_SEPARATOR));
        String responseMode = OpenIdUtil.getConfiguredValue(String.class, definition.responseMode(), provider, "payara.security.openid.responseMode");
        String display = definition.display().toString().toLowerCase();
        display = OpenIdUtil.getConfiguredValue(String.class, display, provider, "payara.security.openid.display");
        String prompt = Arrays.stream(definition.prompt()).map(Enum::toString).map(String::toLowerCase).collect(Collectors.joining(SPACE_SEPARATOR));
        prompt = OpenIdUtil.getConfiguredValue(String.class, prompt, provider, "payara.security.openid.prompt");
        HashMap<String, String> extraParameters = new HashMap<String, String>();
        for (String extraParameter : definition.extraParameters()) {
            String[] parts = extraParameter.split("=");
            String key = parts[0];
            String value = parts[1];
            extraParameters.put(key, value);
        }
        boolean nonce = OpenIdUtil.getConfiguredValue(Boolean.class, definition.useNonce(), provider, "payara.security.openid.useNonce");
        boolean session = OpenIdUtil.getConfiguredValue(Boolean.class, definition.useSession(), provider, "payara.security.openid.useSession");
        int jwksConnectTimeout = OpenIdUtil.getConfiguredValue(Integer.class, definition.jwksConnectTimeout(), provider, "payara.security.openid.jwks.connect.timeout");
        int jwksReadTimeout = OpenIdUtil.getConfiguredValue(Integer.class, definition.jwksReadTimeout(), provider, "payara.security.openid.jwks.read.timeout");
        String encryptionAlgorithm = provider.getOptionalValue("payara.security.openid.client.encryption.algorithm", String.class).orElse(null);
        String encryptionMethod = provider.getOptionalValue("payara.security.openid.client.encryption.method", String.class).orElse(null);
        String privateKeyJWKS = provider.getOptionalValue("payara.security.openid.client.encryption.jwks", String.class).orElse(null);
        String callerNameClaim = OpenIdUtil.getConfiguredValue(String.class, definition.claimsDefinition().callerNameClaim(), provider, "payara.security.openid.callerNameClaim");
        String callerGroupsClaim = OpenIdUtil.getConfiguredValue(String.class, definition.claimsDefinition().callerGroupsClaim(), provider, "payara.security.openid.callerGroupsClaim");
        Boolean notifyProvider = OpenIdUtil.getConfiguredValue(Boolean.class, definition.logout().notifyProvider(), provider, "payara.security.openid.provider.notify.logout");
        String logoutRedirectURI = OpenIdUtil.getConfiguredValue(String.class, definition.logout().redirectURI(), provider, "payara.security.openid.logout.redirectURI");
        Boolean accessTokenExpiry = OpenIdUtil.getConfiguredValue(Boolean.class, definition.logout().accessTokenExpiry(), provider, "payara.security.openid.logout.access.token.expiry");
        Boolean identityTokenExpiry = OpenIdUtil.getConfiguredValue(Boolean.class, definition.logout().identityTokenExpiry(), provider, "payara.security.openid.logout.identity.token.expiry");
        boolean tokenAutoRefresh = OpenIdUtil.getConfiguredValue(Boolean.class, definition.tokenAutoRefresh(), provider, "payara.security.openid.token.autoRefresh");
        int tokenMinValidity = OpenIdUtil.getConfiguredValue(Integer.class, definition.tokenMinValidity(), provider, "payara.security.openid.token.minValidity");
        OpenIdConfiguration configuration = new OpenIdConfiguration().setProviderMetadata(new OpenIdProviderMetadata(providerDocument).setAuthorizationEndpoint(authorizationEndpoint).setTokenEndpoint(tokenEndpoint).setUserinfoEndpoint(userinfoEndpoint).setEndSessionEndpoint(endSessionEndpoint).setJwksURL(jwksURL)).setClaimsConfiguration(new ClaimsConfiguration().setCallerNameClaim(callerNameClaim).setCallerGroupsClaim(callerGroupsClaim)).setLogoutConfiguration(new LogoutConfiguration().setNotifyProvider(notifyProvider).setRedirectURI(logoutRedirectURI).setAccessTokenExpiry(accessTokenExpiry).setIdentityTokenExpiry(identityTokenExpiry)).setEncryptionMetadata(new OpenIdTokenEncryptionMetadata().setEncryptionAlgorithm(encryptionAlgorithm).setEncryptionMethod(encryptionMethod).setPrivateKeySource(privateKeyJWKS)).setClientId(clientId).setClientSecret(clientSecret).setRedirectURI(redirectURI).setScopes(scopes).setResponseType(responseType).setResponseMode(responseMode).setExtraParameters(extraParameters).setPrompt(prompt).setDisplay(display).setUseNonce(nonce).setUseSession(session).setJwksConnectTimeout(jwksConnectTimeout).setJwksReadTimeout(jwksReadTimeout).setTokenAutoRefresh(tokenAutoRefresh).setTokenMinValidity(tokenMinValidity);
        this.validateConfiguration(configuration);
        return configuration;
    }

    private void validateConfiguration(OpenIdConfiguration configuration) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        errorMessages.addAll(this.validateProviderMetadata(configuration));
        errorMessages.addAll(this.validateClientConfiguration(configuration));
        if (!errorMessages.isEmpty()) {
            throw new IllegalStateException(((Object)errorMessages).toString());
        }
    }

    private List<String> validateProviderMetadata(OpenIdConfiguration configuration) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (OpenIdUtil.isEmpty(configuration.getProviderMetadata().getIssuerURI())) {
            errorMessages.add("issuer metadata is mandatory");
        }
        if (OpenIdUtil.isEmpty(configuration.getProviderMetadata().getAuthorizationEndpoint())) {
            errorMessages.add("authorization_endpoint metadata is mandatory");
        }
        if (OpenIdUtil.isEmpty(configuration.getProviderMetadata().getTokenEndpoint())) {
            errorMessages.add("token_endpoint metadata is mandatory");
        }
        if (configuration.getProviderMetadata().getJwksURL() == null) {
            errorMessages.add("jwks_uri metadata is mandatory");
        }
        if (configuration.getProviderMetadata().getResponseTypeSupported().isEmpty()) {
            errorMessages.add("response_types_supported metadata is mandatory");
        }
        if (configuration.getProviderMetadata().getResponseTypeSupported().isEmpty()) {
            errorMessages.add("subject_types_supported metadata is mandatory");
        }
        if (configuration.getProviderMetadata().getIdTokenSigningAlgorithmsSupported().isEmpty()) {
            errorMessages.add("id_token_signing_alg_values_supported metadata is mandatory");
        }
        return errorMessages;
    }

    private List<String> validateClientConfiguration(OpenIdConfiguration configuration) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (OpenIdUtil.isEmpty(configuration.getClientId())) {
            errorMessages.add("client_id request parameter is mandatory");
        }
        if (OpenIdUtil.isEmpty(configuration.getRedirectURI())) {
            errorMessages.add("redirect_uri request parameter is mandatory");
        }
        if (configuration.getJwksConnectTimeout() <= 0) {
            errorMessages.add("jwksConnectTimeout value is not valid");
        }
        if (configuration.getJwksReadTimeout() <= 0) {
            errorMessages.add("jwksReadTimeout value is not valid");
        }
        if (OpenIdUtil.isEmpty(configuration.getResponseType())) {
            errorMessages.add("The response type must contain at least one value");
        } else if (!(configuration.getProviderMetadata().getResponseTypeSupported().contains(configuration.getResponseType()) || OpenIdConstant.AUTHORIZATION_CODE_FLOW_TYPES.contains(configuration.getResponseType()) || OpenIdConstant.IMPLICIT_FLOW_TYPES.contains(configuration.getResponseType()) || OpenIdConstant.HYBRID_FLOW_TYPES.contains(configuration.getResponseType()))) {
            errorMessages.add("Unsupported OpenID Connect response type value : " + configuration.getResponseType());
        }
        Set<String> supportedScopes = configuration.getProviderMetadata().getScopesSupported();
        if (!supportedScopes.isEmpty()) {
            for (String scope : configuration.getScopes().split(SPACE_SEPARATOR)) {
                if (supportedScopes.contains(scope)) continue;
                errorMessages.add(String.format("%s scope is not supported by %s OpenId Connect provider", scope, configuration.getProviderMetadata().getIssuerURI()));
            }
        }
        return errorMessages;
    }

    static CacheKey keyFromDefinition(OpenIdAuthenticationDefinition definition) {
        String[][] values = new String[][]{{definition.providerURI(), definition.clientId(), definition.clientSecret(), definition.redirectURI(), definition.responseType(), definition.responseMode(), Arrays.toString((Object[])definition.prompt()), String.valueOf(definition.useNonce()), String.valueOf(definition.useSession()), String.valueOf(definition.tokenAutoRefresh()), String.valueOf(definition.tokenMinValidity())}, definition.scope(), definition.extraParameters(), ConfigurationController.providerMetadataAttrs(definition.providerMetadata()), ConfigurationController.claimsAttrs(definition.claimsDefinition()), ConfigurationController.logoutAttrs(definition.logout())};
        return new CacheKey(Stream.of(values).flatMap(Stream::of).toArray(String[]::new));
    }

    private static String[] logoutAttrs(LogoutDefinition logout) {
        String[] stringArray;
        if (logout != null) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = String.valueOf(logout.notifyProvider());
            stringArray2[1] = logout.redirectURI();
            stringArray2[2] = String.valueOf(logout.accessTokenExpiry());
            stringArray = stringArray2;
            stringArray2[3] = String.valueOf(logout.identityTokenExpiry());
        } else {
            stringArray = new String[4];
        }
        return stringArray;
    }

    private static String[] claimsAttrs(ClaimsDefinition claimsDefinition) {
        String[] stringArray;
        if (claimsDefinition != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = claimsDefinition.callerGroupsClaim();
            stringArray = stringArray2;
            stringArray2[1] = claimsDefinition.callerNameClaim();
        } else {
            stringArray = new String[2];
        }
        return stringArray;
    }

    private static String[] providerMetadataAttrs(fish.payara.security.annotations.OpenIdProviderMetadata providerMetadata) {
        String[] stringArray;
        if (providerMetadata != null) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = providerMetadata.authorizationEndpoint();
            stringArray2[1] = providerMetadata.tokenEndpoint();
            stringArray2[2] = providerMetadata.userinfoEndpoint();
            stringArray2[3] = providerMetadata.endSessionEndpoint();
            stringArray = stringArray2;
            stringArray2[4] = providerMetadata.jwksURI();
        } else {
            stringArray = new String[5];
        }
        return stringArray;
    }

    static class LastBuiltConfig {
        private final OpenIdAuthenticationDefinition definition;
        private final OpenIdConfiguration configuration;

        public LastBuiltConfig(OpenIdAuthenticationDefinition definition, OpenIdConfiguration configuration) {
            this.definition = definition;
            this.configuration = configuration;
        }

        OpenIdConfiguration cachedConfiguration(OpenIdAuthenticationDefinition definition) {
            if (this.definition != null && this.definition.equals(definition)) {
                return this.configuration;
            }
            return null;
        }
    }
}

