/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.domain;

import fish.payara.security.openid.OpenIdUtil;
import fish.payara.security.openid.api.AccessToken;
import fish.payara.security.openid.api.IdentityToken;
import fish.payara.security.openid.api.OpenIdClaims;
import fish.payara.security.openid.api.OpenIdContext;
import fish.payara.security.openid.api.RefreshToken;
import fish.payara.security.openid.controller.AuthenticationController;
import fish.payara.security.openid.controller.UserInfoController;
import fish.payara.security.openid.domain.JsonClaims;
import fish.payara.security.openid.domain.LogoutConfiguration;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.UriBuilder;

@SessionScoped
public class OpenIdContextImpl
implements OpenIdContext {
    @Inject
    UserInfoController userInfoController;
    private String callerName;
    private Set<String> callerGroups;
    private String tokenType;
    private AccessToken accessToken;
    private IdentityToken identityToken;
    private RefreshToken refreshToken;
    private Long expiresIn;
    private JsonObject claims;
    @Inject
    private OpenIdConfiguration configuration;
    @Inject
    private AuthenticationController authenticationController;
    private static final Logger LOGGER = Logger.getLogger(OpenIdContextImpl.class.getName());

    @Override
    public String getCallerName() {
        return this.callerName;
    }

    public void setCallerName(String callerName) {
        this.callerName = callerName;
    }

    @Override
    public Set<String> getCallerGroups() {
        return this.callerGroups;
    }

    public void setCallerGroups(Set<String> callerGroups) {
        this.callerGroups = callerGroups;
    }

    @Override
    public String getSubject() {
        return (String)this.getIdentityToken().getClaim("sub");
    }

    @Override
    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    @Override
    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(AccessToken token) {
        this.accessToken = token;
    }

    @Override
    public IdentityToken getIdentityToken() {
        return this.identityToken;
    }

    public void setIdentityToken(IdentityToken identityToken) {
        this.identityToken = identityToken;
    }

    @Override
    public Optional<RefreshToken> getRefreshToken() {
        return Optional.ofNullable(this.refreshToken);
    }

    public void setRefreshToken(RefreshToken refreshToken) {
        this.refreshToken = refreshToken;
    }

    @Override
    public Optional<Long> getExpiresIn() {
        return Optional.ofNullable(this.expiresIn);
    }

    public void setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
    }

    @Override
    public JsonObject getClaimsJson() {
        if (this.claims == null) {
            this.claims = this.configuration != null && this.accessToken != null ? this.userInfoController.getUserInfo(this.configuration, this.accessToken) : Json.createObjectBuilder().build();
        }
        return this.claims;
    }

    @Override
    public OpenIdClaims getClaims() {
        return new JsonClaims(this.getClaimsJson());
    }

    @Override
    public JsonObject getProviderMetadata() {
        return this.configuration.getProviderMetadata().getDocument();
    }

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response) {
        LogoutConfiguration logout = this.configuration.getLogoutConfiguration();
        try {
            request.logout();
        }
        catch (ServletException ex) {
            LOGGER.log(Level.WARNING, "Failed to logout the user.", ex);
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        if (logout == null) {
            LOGGER.log(Level.WARNING, "Logout invoked on session without OpenID session");
            OpenIdContextImpl.redirect(response, request.getContextPath());
        }
        if (logout.isNotifyProvider() && !OpenIdUtil.isEmpty(this.configuration.getProviderMetadata().getEndSessionEndpoint())) {
            UriBuilder logoutURI = UriBuilder.fromUri((String)this.configuration.getProviderMetadata().getEndSessionEndpoint()).queryParam("id_token_hint", new Object[]{this.getIdentityToken().getToken()});
            if (!OpenIdUtil.isEmpty(logout.getRedirectURI())) {
                logoutURI.queryParam("post_logout_redirect_uri", new Object[]{logout.buildRedirectURI(request)});
            }
            OpenIdContextImpl.redirect(response, logoutURI.toString());
        } else if (!OpenIdUtil.isEmpty(logout.getRedirectURI())) {
            OpenIdContextImpl.redirect(response, logout.buildRedirectURI(request));
        } else {
            this.authenticationController.authenticateUser(request, response);
        }
    }

    private static void redirect(HttpServletResponse response, String uri) {
        try {
            response.sendRedirect(uri);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

