/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility.generator;

import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.generator.JavaClassWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.StringTokenizer;

public class JavaClassWriterHelper
extends JavaTypeHelper {
    public static final String javaExtension_ = ".java";
    public static final String void_ = "void";
    public static final String boolean_ = "boolean";
    public static final String byte_ = "byte";
    public static final String byteArray_ = "byte[]";
    public static final String param_ = "param";
    public static final String param0_ = "param0";
    public static final String null_ = "null";
    public static final String home_ = "home";
    public static final String delim_ = ";";
    public static final String paramInitializer_ = "\"\" + ";
    public static final String paramSeparator_ = ", ";
    public static final String paramList_ = ",";
    public static final String paramConcatenator_ = " + \", \" + ";
    public static final String space_ = " ";
    public static final String none_ = "";
    public static final String escapedEmptyString_ = "\"\"";
    public static final String dot_ = ".";
    public static final String parenleft_ = "(";
    public static final String parenright_ = ")";
    public static final String parenthesis_ = "()";
    public static final String new_ = "new";
    public static final String endLine_ = "\n";
    public static final String true_ = "true";
    public static final String false_ = "false";
    public static final String Collection_ = "java.util.Collection";
    public static final String Set_ = "java.util.Set";
    public static final String PersistenceCapable_ = "com.sun.jdo.api.persistence.support.PersistenceCapable";
    public static final String brackets_ = "[]";
    public static final String get_ = "get";
    public static final String set_ = "set";
    public static final String Oid_ = ".Oid";
    public static final String Helper_ = "_JDOHelper";
    public static final String returnNull_ = "return null;";
    public static final String fileName_ = "fileName";
    public static final String int_ = "int";
    public static final String String_ = "java.lang.String";
    public static final String Class_ = "java.lang.Class";
    public static final String Date_ = "java.util.Date";
    public static final String SqlDate_ = "java.sql.Date";
    public static final String SqlTime_ = "java.sql.Time";
    public static final String SqlTimestamp_ = "java.sql.Timestamp";
    public static final String Object_ = "Object";
    public static final String[] super_ = new String[]{"super();"};
    private static final String[] indentation_ = new String[]{"    ", "        ", "            ", "                "};

    public static String[] getBodyAsStrings(String body) {
        StringTokenizer st = new StringTokenizer(body, endLine_);
        String[] rc = new String[st.countTokens()];
        int ii = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int i = s.lastIndexOf(9);
            rc[ii] = i > -1 ? indentation_[i] + s.substring(i + 1) : s;
            ++ii;
        }
        return rc;
    }

    public static Class getWrapperType(Class cls) {
        Class rc = JavaClassWriterHelper.getWrapperClass(cls);
        if (rc == null) {
            rc = cls;
        }
        return rc;
    }

    public static String getWrapperExpr(Class exprType, String expr) {
        StringBuilder wrapped = new StringBuilder();
        wrapped.append(new_);
        wrapped.append(space_);
        wrapped.append(JavaClassWriterHelper.getWrapperType(exprType).getName());
        wrapped.append(parenleft_);
        wrapped.append(expr);
        wrapped.append(parenright_);
        return wrapped.toString();
    }

    public static String getUnwrapMethodName(Class primitiveType) {
        return primitiveType.getName() + "Value()";
    }

    public static String getPrimitiveType(Class cls) {
        String rc = JavaClassWriterHelper.getPrimitiveName(cls);
        if (rc == null) {
            rc = cls.getName();
        }
        return rc;
    }

    public static String[] getExceptionNames(Method m) {
        Class<?>[] cls = m.getExceptionTypes();
        String[] rc = new String[cls.length];
        for (int ii = 0; ii < cls.length; ++ii) {
            rc[ii] = cls[ii].getName();
        }
        return rc;
    }

    public static String getParameterTypesList(Method m) {
        if (m == null) {
            return none_;
        }
        StringBuilder buf = new StringBuilder();
        Class<?>[] paramTypes = m.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                buf.append(paramList_);
            }
            buf.append(JavaClassWriterHelper.getTypeRepr(paramTypes[i]));
        }
        return buf.toString();
    }

    public static String getParametersList(Method m) {
        return JavaClassWriterHelper.getParametersListWithSeparator(m, paramSeparator_);
    }

    public static String getParametersListWithSeparator(Method m, String sep) {
        int count = m.getParameterTypes().length;
        StringBuilder rc = new StringBuilder();
        for (int ii = 0; ii < count; ++ii) {
            if (ii > 0) {
                rc.append(sep);
            }
            rc.append(param_ + ii);
        }
        return rc.toString();
    }

    public static void addFields(String prop, int modifiers, JavaClassWriter writer) throws IOException {
        String[] v = JavaClassWriterHelper.getBodyAsStrings(prop);
        for (int i = 0; i < v.length; ++i) {
            StringTokenizer st = new StringTokenizer(v[i], space_);
            String type = st.nextToken();
            String name = st.nextToken();
            StringBuilder value = new StringBuilder();
            while (st.hasMoreTokens()) {
                value.append(st.nextToken() + space_);
            }
            int l = value.length();
            value.deleteCharAt(l - 1);
            writer.addField(name, modifiers, type, value.toString(), null);
        }
    }

    public static void addPrivateField(String prop, int modifiers, JavaClassWriter writer) throws IOException {
        JavaClassWriterHelper.addFields(prop, 2 + modifiers, writer);
    }

    public static void addGenericMethod(String mname, String[] body, JavaClassWriter writer) throws IOException {
        JavaClassWriterHelper.addGenericMethod(mname, void_, body, writer);
    }

    public static void addGenericMethod(String mname, String type, String[] body, JavaClassWriter writer) throws IOException {
        JavaClassWriterHelper.addGenericMethod(mname, 2, type, body, writer);
    }

    public static void addGenericMethod(String mname, int modifiers, String[] body, JavaClassWriter writer) throws IOException {
        JavaClassWriterHelper.addGenericMethod(mname, modifiers, void_, body, writer);
    }

    public static void addGenericMethod(String mname, int modifiers, String type, String[] body, JavaClassWriter writer) throws IOException {
        writer.addMethod(mname, modifiers, type, null, null, null, body, null);
    }

    public static void addGenericMethod(Method m, String mname, String mtype, String body, JavaClassWriter writer) throws IOException {
        Class<?>[] types = m.getParameterTypes();
        int count = types.length;
        String[] parameterTypes = new String[count];
        String[] parameterNames = new String[count];
        for (int ii = 0; ii < count; ++ii) {
            parameterTypes[ii] = JavaClassWriterHelper.getTypeRepr(types[ii]);
            parameterNames[ii] = param_ + ii;
        }
        String[] exceptionTypes = JavaClassWriterHelper.getExceptionNames(m);
        int modifiers = m.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            modifiers -= 1024;
        }
        writer.addMethod(mname, modifiers, mtype, parameterNames, parameterTypes, exceptionTypes, JavaClassWriterHelper.getBodyAsStrings(body), null);
    }

    public static String getTypeRepr(Class clazz) {
        return clazz.isArray() ? JavaClassWriterHelper.getTypeRepr(clazz.getComponentType()) + brackets_ : clazz.getName();
    }
}

