/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.model;

import fish.payara.monitoring.model.Series;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public final class SeriesAnnotation
implements Serializable,
Iterable<Map.Entry<String, String>> {
    private final long time;
    private final Series series;
    private final String instance;
    private final long value;
    private final boolean keyed;
    private final String[] attrs;
    private final boolean permanent;

    public SeriesAnnotation(long time, Series series, String instance, long value, boolean keyed, String ... attrs) {
        this(time, series, instance, value, keyed, attrs, false);
    }

    private SeriesAnnotation(long time, Series series, String instance, long value, boolean keyed, String[] attrs, boolean permanent) {
        if (attrs.length % 2 == 1) {
            throw new IllegalArgumentException("Annotation attributes always must be given in pairs but got: " + Arrays.toString(attrs));
        }
        this.time = time;
        this.series = series;
        this.instance = instance;
        this.value = value;
        this.keyed = keyed && attrs.length >= 2;
        this.attrs = attrs;
        this.permanent = permanent;
    }

    public SeriesAnnotation permanent() {
        return new SeriesAnnotation(this.time, this.series, this.instance, this.value, this.keyed, this.attrs, true);
    }

    public long getTime() {
        return this.time;
    }

    public long getValue() {
        return this.value;
    }

    public Series getSeries() {
        return this.series;
    }

    public String getInstance() {
        return this.instance;
    }

    public boolean isKeyed() {
        return this.keyed;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public String getKeyAttribute() {
        return this.isKeyed() ? this.attrs[1] : null;
    }

    public int getAttriuteCount() {
        return this.attrs.length / 2;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        final String[] elems = this.attrs;
        return new Iterator<Map.Entry<String, String>>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < elems.length;
            }

            @Override
            public Map.Entry<String, String> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more attribute available.");
                }
                return new AbstractMap.SimpleImmutableEntry<String, String>(elems[this.i++], elems[this.i++]);
            }
        };
    }

    public int hashCode() {
        return this.series.hashCode() ^ this.instance.hashCode() ^ (int)this.time;
    }

    public boolean equals(Object obj) {
        return obj instanceof SeriesAnnotation && this.equalTo((SeriesAnnotation)obj);
    }

    public boolean equalTo(SeriesAnnotation other) {
        return this.time == other.time && this.series.equalTo(other.series) && this.instance.equals(other.instance);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.instance).append(' ').append(this.series.toString()).append('=').append(this.value).append(' ').append(this.time);
        str.append(":[");
        for (int i = 0; i < this.attrs.length; i += 2) {
            str.append("\n\t").append(this.attrs[i]).append('=').append(this.attrs[i + 1]);
        }
        str.append("\n]");
        return str.toString();
    }
}

